% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgTools.R
\name{pg_addColumn}
\alias{pg_addColumn}
\title{Helper command to add a column via ALTER TABLE.}
\usage{
pg_addColumn(
  column_name,
  data_type,
  default = NULL,
  constraint = NULL,
  if_not_exists = FALSE
)
}
\arguments{
\item{column_name}{A string, the name of the column to add.}

\item{data_type}{A string, the data type of the column to add.}

\item{default}{A string, a default value for the column to add.}

\item{constraint}{A string, a constraint for the column to add.}

\item{if_not_exists}{Boolean, if TRUE, adds IF NOT EXISTS to the ADD COLUMN statement.}
}
\value{
A string, PostgreSQL helper statement to add a column using ALTER TABLE.
}
\description{
Helper command to add a column via ALTER TABLE.
}
\examples{
pg_addColumn(
column_name = "newCol",
data_type = "text"
)
}
