% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgTools.R
\name{COPY}
\alias{COPY}
\title{Generate a PostgreSQL COPY command, optionally execute the statement if con is not NULL.}
\usage{
COPY(
  schema = NULL,
  table,
  columns = NULL,
  file,
  type = "FROM",
  delimiter = ",",
  format = "csv",
  query = NULL,
  header = TRUE,
  con = NULL
)
}
\arguments{
\item{schema}{A string, the schema of the table to copy from/to.}

\item{table}{A string, the table to copy from/to.}

\item{columns}{A vector, columns to read/write.}

\item{file}{A string, the file path and name to read/write.}

\item{type}{A string, "FROM" or "TO".}

\item{delimiter}{A string, the delimiter.}

\item{format}{A string, "CSV", "TEXT", or "BINARY".}

\item{query}{A string, the query used to select data for output.}

\item{header}{TRUE/FALSE, if TRUE, adds HEADER to statement.}

\item{con}{A database connection that can be passed to DBI::dbSendQuery/DBI::dbGetQuery.}
}
\value{
A string, PostgreSQL COPY command; or the results retrieved by DBI::dbExecute after executing the statement.
}
\description{
Generate a PostgreSQL COPY command, optionally execute the statement if con is not NULL.
}
\examples{
COPY(
table = "table1",
file = "/home/test/test.csv"
)
}
