% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgTools.R
\name{querySELECT}
\alias{querySELECT}
\title{Generate a PostgreSQL select statement, optionally execute the statement if con is not NULL.}
\usage{
querySELECT(
  select,
  from = list(),
  where = NULL,
  group_by = NULL,
  having = NULL,
  order_by = NULL,
  con = NULL
)
}
\arguments{
\item{select}{A vector of columns/items to select.}

\item{from}{A string, the table(s) to select from.}

\item{where}{A string, text to include in the where clause.}

\item{group_by}{A vector of columns/items to group by.}

\item{having}{A vector of conditions to be met by aggregations.}

\item{order_by}{A vector of columns/items to order by.}

\item{con}{A database connection that can be passed to DBI::dbSendQuery/DBI::dbGetQuery.}
}
\value{
A string, PostgreSQL select statement; or the results retrieved by DBI::dbGetQuery after executing the statement.
}
\description{
Generate a PostgreSQL select statement, optionally execute the statement if con is not NULL.
}
\examples{
querySELECT(
select = c("col1", "col2", "col1 + col2 AS col3"),
from = "schema1.table1"
)
}
