/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps.resources;

import java.util.logging.Logger;
import net.sf.eps2pgf.ProgramError;
import net.sf.eps2pgf.ps.errors.PSError;
import net.sf.eps2pgf.ps.errors.PSErrorUndefinedResource;
import net.sf.eps2pgf.ps.errors.PSErrorUnimplemented;
import net.sf.eps2pgf.ps.objects.PSObject;
import net.sf.eps2pgf.ps.objects.PSObjectArray;
import net.sf.eps2pgf.ps.objects.PSObjectBool;
import net.sf.eps2pgf.ps.objects.PSObjectDict;
import net.sf.eps2pgf.ps.objects.PSObjectInt;
import net.sf.eps2pgf.ps.objects.PSObjectName;
import net.sf.eps2pgf.ps.resources.colors.ColorManager;
import net.sf.eps2pgf.ps.resources.filters.FilterManager;
import net.sf.eps2pgf.ps.resources.fonts.FontManager;

public final class ResourceManager {
    private static final Logger LOG = Logger.getLogger("net.sourceforge.eps2pgf");
    public static final PSObjectName CAT_FONT = new PSObjectName("/Font");
    public static final PSObjectName CAT_CIDFONT = new PSObjectName("/CIDFont");
    public static final PSObjectName CAT_CMAP = new PSObjectName("/CMAP");
    public static final PSObjectName CAT_FONTSET = new PSObjectName("/FontSet");
    public static final PSObjectName CAT_ENCODING = new PSObjectName("/Encoding");
    public static final PSObjectName CAT_FORM = new PSObjectName("/Form");
    public static final PSObjectName CAT_PATTERN = new PSObjectName("/Pattern");
    public static final PSObjectName CAT_PROCSET = new PSObjectName("/ProcSet");
    public static final PSObjectName CAT_COLORSPACE = new PSObjectName("/ColorSpace");
    public static final PSObjectName CAT_HALFTONE = new PSObjectName("/Halftone");
    public static final PSObjectName CAT_COLORRENDERING = new PSObjectName("/ColorRendering");
    public static final PSObjectName CAT_IDIOMSET = new PSObjectName("/IdiomSet");
    public static final PSObjectName CAT_INKPARAMS = new PSObjectName("/InkParams");
    public static final PSObjectName CAT_TRAPPARAMS = new PSObjectName("/TrapParams");
    public static final PSObjectName CAT_OUTPUTDEVICE = new PSObjectName("/OutputDevice");
    public static final PSObjectName CAT_CONTROLLANGUAGE = new PSObjectName("/ControlLanguage");
    public static final PSObjectName CAT_LOCALIZATION = new PSObjectName("/Localization");
    public static final PSObjectName CAT_PDL = new PSObjectName("/PDL");
    public static final PSObjectName CAT_HWOPTIONS = new PSObjectName("/HWOptions");
    public static final PSObjectName CAT_COLORSPACEFAMILY = new PSObjectName("/ColorSpaceFamily");
    public static final PSObjectName CAT_FONTTYPE = new PSObjectName("/FontType");
    public static final PSObjectName CAT_FILTER = new PSObjectName("/Filter");
    private static final PSObjectName[] REGULAR_CATS = new PSObjectName[]{CAT_FONT, CAT_CIDFONT, CAT_CMAP, CAT_FONTSET, CAT_ENCODING, CAT_FORM, CAT_PATTERN, CAT_PROCSET, CAT_COLORSPACE, CAT_HALFTONE, CAT_COLORRENDERING, CAT_IDIOMSET, CAT_INKPARAMS, CAT_TRAPPARAMS, CAT_OUTPUTDEVICE, CAT_CONTROLLANGUAGE, CAT_LOCALIZATION, CAT_PDL, CAT_HWOPTIONS};
    private FontManager fontManager = new FontManager();
    private PSObjectDict resources = new PSObjectDict();

    public ResourceManager() throws ProgramError {
        for (int i = 0; i < REGULAR_CATS.length; ++i) {
            this.resources.setKey((PSObject)REGULAR_CATS[i], (PSObject)new PSObjectDict());
        }
    }

    public PSObject defineResource(PSObjectName pSObjectName, PSObject pSObject, PSObject pSObject2) throws PSError, ProgramError {
        LOG.fine("Defining resource " + pSObjectName.isis() + " " + pSObject.isis() + " " + pSObject2.isis());
        if (pSObjectName.eq(CAT_FONT)) {
            return this.fontManager.defineFont(pSObject, pSObject2.toFont());
        }
        if (pSObjectName.eq(CAT_COLORSPACE)) {
            ColorManager.autoSetColorSpace(pSObject2);
        }
        PSObjectDict pSObjectDict = this.resources.get(pSObjectName).toDict();
        pSObjectDict.setKey(pSObject, pSObject2);
        pSObject2.readonly();
        return pSObject2;
    }

    public PSObject findResource(PSObjectName pSObjectName, PSObject pSObject) throws PSError, ProgramError {
        PSObject pSObject2 = null;
        if (pSObjectName.eq(CAT_FONT)) {
            pSObject2 = this.fontManager.findFont(pSObject);
        } else {
            PSObjectDict pSObjectDict = this.resources.get(pSObjectName).toDict();
            pSObject2 = pSObjectDict.lookup(pSObject);
            if (pSObject2 == null) {
                throw new PSErrorUndefinedResource();
            }
        }
        return pSObject2;
    }

    public PSObjectArray resourceStatus(PSObjectName pSObjectName, PSObject pSObject) throws PSError {
        boolean bl;
        if (pSObjectName.eq(CAT_FONTTYPE)) {
            bl = this.fontManager.fontTypeStatus(pSObject);
        } else if (pSObjectName.eq(CAT_FILTER)) {
            bl = FilterManager.filterStatus(pSObject);
        } else if (pSObjectName.eq(CAT_COLORSPACEFAMILY)) {
            bl = ColorManager.colorSpaceFamilyStatus(pSObject);
        } else {
            throw new PSErrorUnimplemented("Checking resources of type: " + pSObjectName.isis());
        }
        PSObjectArray pSObjectArray = new PSObjectArray();
        if (bl) {
            pSObjectArray.addToEnd(new PSObjectInt(0));
            pSObjectArray.addToEnd(new PSObjectInt(0));
        }
        pSObjectArray.addToEnd(new PSObjectBool(bl));
        return pSObjectArray;
    }

    public FontManager getFontManager() {
        return this.fontManager;
    }
}

