/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.io;

import java.io.IOException;
import java.io.InputStream;
import net.sf.eps2pgf.ps.errors.PSErrorRangeCheck;
import net.sf.eps2pgf.ps.objects.PSObjectString;

public class PSStringInputStream
extends InputStream {
    private PSObjectString string;
    private int ptr;
    private int lastMark;

    public PSStringInputStream(PSObjectString pSObjectString) {
        this.string = pSObjectString;
        this.ptr = 0;
        this.lastMark = -1;
    }

    public void mark(int n) {
        this.lastMark = this.ptr;
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        try {
            int n = this.string.get(this.ptr);
            if (n < 0 || n > 255) {
                throw new IOException();
            }
            ++this.ptr;
            return n;
        }
        catch (PSErrorRangeCheck pSErrorRangeCheck) {
            return -1;
        }
    }

    public void reset() throws IOException {
        if (this.lastMark < 0) {
            throw new IOException();
        }
        this.ptr = this.lastMark;
    }
}

