/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps;

import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DSCHeader {
    private double[] boundingBox = null;
    private Pattern dscRegExp = Pattern.compile("%%(\\w+):?\\s*(.*)\\s*");

    public DSCHeader(InputStream inputStream) throws IOException {
        this.loadAllDSCComments(inputStream);
    }

    public DSCHeader(double[] dArray) {
        this.boundingBox = (double[])dArray.clone();
    }

    void loadAllDSCComments(InputStream inputStream) throws IOException {
        String[] stringArray;
        while ((stringArray = this.readDSCComment(inputStream)) != null) {
            String string = stringArray[0].toLowerCase();
            if (string.equals("hiresboundingbox")) {
                this.boundingBox = this.parseBoundingBox(stringArray[1]);
                continue;
            }
            if (string.equals("exactboundingbox")) {
                this.boundingBox = this.parseBoundingBox(stringArray[1]);
                continue;
            }
            if (!string.equals("boundingbox") || this.boundingBox != null) continue;
            this.boundingBox = this.parseBoundingBox(stringArray[1]);
        }
    }

    double[] parseBoundingBox(String string) {
        Matcher matcher = Pattern.compile("\\s*(\\S*)\\s+(\\S*)\\s+(\\S*)\\s+(\\S*)\\s*").matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        double[] dArray = new double[]{Double.parseDouble(matcher.group(1)), Double.parseDouble(matcher.group(2)), Double.parseDouble(matcher.group(3)), Double.parseDouble(matcher.group(4))};
        return dArray;
    }

    String[] readDSCComment(InputStream inputStream) throws IOException {
        String[] stringArray;
        Matcher matcher;
        do {
            if ((stringArray = this.readCommentLine(inputStream)).length() != 0) continue;
            return null;
        } while (!(matcher = this.dscRegExp.matcher((CharSequence)stringArray)).matches());
        stringArray = new String[]{matcher.group(1), matcher.group(2)};
        return stringArray;
    }

    String readCommentLine(InputStream inputStream) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        inputStream.mark(1);
        while ((n = inputStream.read()) != -1) {
            if (n == 10 || n == 12 || n == 13) {
                if (stringBuilder.length() > 0) {
                    bl = true;
                }
            } else {
                if (bl) {
                    inputStream.reset();
                    break;
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.append((char)n);
                } else if (n == 37) {
                    stringBuilder.append((char)n);
                } else {
                    inputStream.reset();
                    break;
                }
            }
            inputStream.mark(1);
        }
        return stringBuilder.toString();
    }

    public double[] getBoundingBox() {
        if (this.boundingBox != null) {
            return (double[])this.boundingBox.clone();
        }
        return null;
    }
}

