/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps.resources.colors;

import net.sf.eps2pgf.ProgramError;
import net.sf.eps2pgf.ps.errors.PSError;
import net.sf.eps2pgf.ps.errors.PSErrorRangeCheck;
import net.sf.eps2pgf.ps.errors.PSErrorTypeCheck;
import net.sf.eps2pgf.ps.objects.PSObject;
import net.sf.eps2pgf.ps.objects.PSObjectArray;
import net.sf.eps2pgf.ps.objects.PSObjectDict;
import net.sf.eps2pgf.ps.objects.PSObjectName;
import net.sf.eps2pgf.ps.resources.colors.CIEBased;

public class CIEBasedABC
extends CIEBased {
    public static final PSObjectName FAMILYNAME = new PSObjectName("/CIEBasedABC");
    private static final PSObjectName RANGEABC = new PSObjectName("/RangeABC");
    private static final PSObjectName DECODEABC = new PSObjectName("/DecodeABC");
    private static final PSObjectName MATRIXABC = new PSObjectName("/MatrixABC");

    public CIEBasedABC(PSObjectArray pSObjectArray) throws PSError, ProgramError {
        if (!pSObjectArray.get(0).eq(FAMILYNAME)) {
            throw new PSErrorTypeCheck();
        }
        this.setDict(CIEBasedABC.checkEntries(pSObjectArray.get(1).toDict()));
    }

    static PSObjectDict checkEntries(PSObjectDict pSObjectDict) throws PSError, ProgramError {
        Object object;
        if (!pSObjectDict.known(RANGEABC)) {
            object = new double[]{0.0, 1.0, 0.0, 1.0, 0.0, 1.0};
            pSObjectDict.setKey((PSObject)RANGEABC, (PSObject)new PSObjectArray((double[])object));
        }
        if (!pSObjectDict.known(DECODEABC)) {
            object = new PSObjectArray();
            ((PSObjectArray)object).addToEnd(new PSObjectArray("{}"));
            ((PSObjectArray)object).addToEnd(new PSObjectArray("{}"));
            ((PSObjectArray)object).addToEnd(new PSObjectArray("{}"));
            pSObjectDict.setKey((PSObject)DECODEABC, (PSObject)object);
        }
        if (!pSObjectDict.known(MATRIXABC)) {
            object = new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0};
            pSObjectDict.setKey((PSObject)MATRIXABC, (PSObject)new PSObjectArray((double[])object));
        }
        CIEBasedABC.checkCommonEntries(pSObjectDict);
        return pSObjectDict;
    }

    public PSObjectName getFamilyName() {
        return FAMILYNAME;
    }

    public int getNrComponents() {
        return 3;
    }

    public int getNrInputValues() {
        return 3;
    }

    public void setColor(double[] dArray) throws PSError, ProgramError {
        int n = this.getNrInputValues();
        if (dArray.length != n) {
            throw new PSErrorRangeCheck();
        }
        for (int i = 0; i < n; ++i) {
            this.setLevel(i, dArray[i]);
        }
        this.setXyzLevels(this.abcToXyz(dArray));
    }

    double[] abcToXyz(double[] dArray) throws PSError, ProgramError {
        PSObjectDict pSObjectDict = this.getDict();
        double[] dArray2 = new double[3];
        PSObjectArray pSObjectArray = pSObjectDict.get(RANGEABC).toArray();
        for (int i = 0; i < 3; ++i) {
            double d = pSObjectArray.getReal(2 * i);
            double d2 = pSObjectArray.getReal(2 * i + 1);
            dArray2[i] = Math.max(d, Math.min(d2, dArray[i]));
        }
        double[] dArray3 = new double[3];
        PSObjectArray pSObjectArray2 = pSObjectDict.get(DECODEABC).toArray();
        for (int i = 0; i < 3; ++i) {
            PSObjectArray pSObjectArray3 = pSObjectArray2.get(i).toProc();
            dArray3[i] = CIEBasedABC.decode(this.getLevel(i), pSObjectArray3);
        }
        double[] dArray4 = new double[3];
        PSObjectArray pSObjectArray4 = pSObjectDict.get(MATRIXABC).toArray();
        for (int i = 0; i < 3; ++i) {
            dArray4[i] = pSObjectArray4.getReal(i) * dArray3[0] + pSObjectArray4.getReal(3 + i) * dArray3[1] + pSObjectArray4.getReal(6 + i) * dArray3[2];
        }
        return this.lmnToXyz(dArray4);
    }
}

