% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{rtma_qqplot}
\alias{rtma_qqplot}
\title{Diagnostic quantile-quantile plot for a right-truncated meta-analysis}
\usage{
rtma_qqplot(rtma)
}
\arguments{
\item{rtma}{Output of \code{\link[=phacking_meta]{phacking_meta()}}.}
}
\description{
To assess the fit of right-truncated meta-analysis and possible violations of
its distributional assumptions, plots the fitted cumulative distribution
function (CDF) of the published nonaffirmative estimates versus their
empirical CDF. If the points do not adhere fairly closely to a 45-degree
line, the right-truncated meta-analysis may not fit adequately.
}
\examples{
\donttest{
money_priming_rtma <- phacking_meta(money_priming_meta$yi,
                                    money_priming_meta$vi,
                                    parallelize = FALSE)
rtma_qqplot(money_priming_rtma)
}
}
