% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phyDat.R
\name{phyDat}
\alias{phyDat}
\alias{as.phyDat.character}
\alias{as.phyDat.data.frame}
\alias{as.phyDat.matrix}
\alias{as.MultipleAlignment}
\alias{as.MultipleAlignment.phyDat}
\alias{cbind.phyDat}
\alias{c.phyDat}
\alias{acgt2ry}
\alias{removeUndeterminedSites}
\alias{phyDat2MultipleAlignment}
\alias{as.phyDat}
\alias{as.phyDat.factor}
\alias{as.phyDat.DNAbin}
\alias{as.phyDat.alignment}
\alias{phyDat2alignment}
\alias{as.phyDat.MultipleAlignment}
\alias{as.character.phyDat}
\alias{as.data.frame.phyDat}
\alias{as.DNAbin.phyDat}
\alias{as.AAbin.phyDat}
\alias{baseFreq}
\alias{subset.phyDat}
\alias{[.phyDat}
\alias{unique.phyDat}
\alias{allSitePattern}
\alias{genlight2phyDat}
\alias{image.phyDat}
\title{Conversion among Sequence Formats}
\usage{
phyDat(data, type = "DNA", levels = NULL, return.index = TRUE, ...)

as.phyDat(x, ...)

\method{as.phyDat}{factor}(x, ...)

\method{as.phyDat}{DNAbin}(x, ...)

\method{as.phyDat}{alignment}(x, type = "DNA", ...)

phyDat2alignment(x)

\method{as.phyDat}{MultipleAlignment}(x, ...)

\method{as.MultipleAlignment}{phyDat}(x, ...)

acgt2ry(obj)

\method{as.character}{phyDat}(x, allLevels = TRUE, ...)

\method{as.data.frame}{phyDat}(x, ...)

\method{as.DNAbin}{phyDat}(x, ...)

\method{as.AAbin}{phyDat}(x, ...)

baseFreq(obj, freq = FALSE, all = FALSE, drop.unused.levels = FALSE)

\method{subset}{phyDat}(x, subset, select, site.pattern = TRUE, ...)

\method{[}{phyDat}(x, i, j, ..., drop = FALSE)

\method{unique}{phyDat}(x, incomparables = FALSE, identical = TRUE, ...)

removeUndeterminedSites(x, ...)

allSitePattern(n, levels = c("a", "c", "g", "t"), names = NULL)

genlight2phyDat(x, ambiguity = NA)

\method{image}{phyDat}(x, ...)
}
\arguments{
\item{data}{An object containing sequences.}

\item{type}{Type of sequences ("DNA", "AA", "CODON" or "USER").}

\item{levels}{Level attributes.}

\item{return.index}{If TRUE returns a index of the site patterns.}

\item{...}{further arguments passed to or from other methods.}

\item{x}{An object containing sequences.}

\item{obj}{as object of class phyDat}

\item{allLevels}{return original data.}

\item{freq}{logical, if 'TRUE', frequencies or counts are returned otherwise
proportions}

\item{all}{all a logical; if all = TRUE, all counts of bases, ambiguous
codes, missing data, and alignment gaps are returned as defined in the
contrast.}

\item{drop.unused.levels}{logical, drop unused levels}

\item{subset}{a subset of taxa.}

\item{select}{a subset of characters.}

\item{site.pattern}{select site pattern or sites.}

\item{i, j}{indices of the rows and/or columns to select or to drop. They
may be numeric, logical, or character (in the same way than for standard R
objects).}

\item{drop}{for compatibility with the generic (unused).}

\item{incomparables}{for compatibility with unique.}

\item{identical}{if TRUE (default) sequences have to be identical, if FALSE
sequences are considered duplicates if distance between sequences is zero
(happens frequently with ambiguous sites).}

\item{n}{Number of sequences.}

\item{names}{Names of sequences.}

\item{ambiguity}{character for ambiguous character and no contrast is
provided.}
}
\value{
The functions return an object of class \code{phyDat}.
}
\description{
These functions transform several DNA formats into the \code{phyDat} format.
\code{allSitePattern} generates an alignment of all possible site patterns.
}
\details{
If \code{type} "USER" a vector has to be give to \code{levels}. For example
c("a", "c", "g", "t", "-") would create a data object that can be used in
phylogenetic analysis with gaps as fifth state.  There is a more detailed
example for specifying "USER" defined data formats in the vignette
"phangorn-specials".

\code{allSitePattern} returns all possible site patterns and can be useful
in simulation studies. For further details see the vignette
phangorn-specials.

The generic function \code{c} can be used to to combine sequences and
\code{unique} to get all unique sequences or unique haplotypes.

\code{acgt2ry} converts a \code{phyDat} object of nucleotides into an binary
ry-coded dataset.
}
\examples{

data(Laurasiatherian)
class(Laurasiatherian)
Laurasiatherian
# base frequencies
baseFreq(Laurasiatherian)
baseFreq(Laurasiatherian, all=TRUE)
baseFreq(Laurasiatherian, freq=TRUE)
# subsetting phyDat objects
# the first 5 sequences
subset(Laurasiatherian, subset=1:5)
# the first 5 characters
subset(Laurasiatherian, select=1:5, site.pattern = FALSE)
# subsetting with []
Laurasiatherian[1:5, 1:20]
# short for
subset(Laurasiatherian, subset=1:5, select=1:20, site.pattern = FALSE)
# the first 5 site patterns (often more than 5 characters)
subset(Laurasiatherian, select=1:5, site.pattern = TRUE)
# transform into old ape format
LauraChar <- as.character(Laurasiatherian)
# and back
Laura <- phyDat(LauraChar)
all.equal(Laurasiatherian, Laura)
# Compute all possible site patterns
# for nucleotides there $4 ^ (number of tips)$ patterns
allSitePattern(5)

}
\seealso{
\code{\link{DNAbin}}, \code{\link{as.DNAbin}},
\code{\link{read.dna}}, \code{\link{read.aa}}, \code{\link{read.nexus.data}}
and the chapter 1 in the \code{vignette("phangorn-specials",
package="phangorn")} and the example of \code{\link{pmlMix}} for the use of
\code{allSitePattern}
}
\author{
Klaus Schliep \email{klaus.schliep@gmail.com}
}
\keyword{cluster}
