% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{set_estimation_step}
\alias{set_estimation_step}
\title{set_estimation_step}
\usage{
set_estimation_step(model, method, interaction = TRUE, options = NULL, idx = 0)
}
\arguments{
\item{model}{(Model) Pharmpy model}

\item{method}{(str) estimation method to change to}

\item{interaction}{(logical) whether to use interaction or not, default is true}

\item{options}{(list) any additional options. Note that this replaces old options (see
append_estimation_step_options to keep old options)}

\item{idx}{(integer) index of estimation step, default is 0 (first estimation step)}
}
\value{
(Model) Reference to the same model object
}
\description{
Set estimation step

Sets estimation step for a model. Methods currently supported are:
FO, FOCE, ITS, LAPLACE, IMPMAP, IMP, SAEM, BAYES
}
\examples{
\dontrun{
model <- load_example_model("pheno")
opts <- list('NITER'=1000, 'ISAMPLE'=100, 'EONLY'=1)
set_estimation_step(model, "IMP", options=opts)
model$estimation_steps[1]
}
}
\seealso{
add_estimation_step

remove_estimation_step

append_estimation_step_options
}
