% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{add_allometry}
\alias{add_allometry}
\title{add_allometry}
\usage{
add_allometry(
  model,
  allometric_variable = "WT",
  reference_value = 70,
  parameters = NULL,
  initials = NULL,
  lower_bounds = NULL,
  upper_bounds = NULL,
  fixed = TRUE
)
}
\arguments{
\item{model}{(Model) Pharmpy model}

\item{allometric_variable}{(str or Symbol) Variable to use for allometry (X above)}

\item{reference_value}{(str, integer, numeric or expression) Reference value (Z above)}

\item{parameters}{(vector) Parameters to use or NULL (default) for all available CL, Q and V parameters}

\item{initials}{(vector) Initial estimates for the exponents. Default is to use 0.75 for CL and Qs and 1 for Vs}

\item{lower_bounds}{(vector) Lower bounds for the exponents. Default is 0 for all parameters}

\item{upper_bounds}{(vector) Upper bounds for the exponents. Default is 2 for all parameters}

\item{fixed}{(logical) Whether the exponents should be fixed}
}
\value{
(Model) Pharmpy model object
}
\description{
Add allometric scaling of parameters

Add an allometric function to each listed parameter. The function will be
P=P*(X/Z)**T where P is the parameter, X the allometric_variable, Z the reference_value
and T is a theta. Default is to automatically use clearance and volume parameters.
}
\examples{
\dontrun{
model <- load_example_model("pheno")
add_allometry(model, allometric_variable='WGT')
model$statements$before_odes
}

}
