% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sleepData.R
\name{sleepData}
\alias{sleepData}
\title{Equivalent of binData() but for sleep data}
\usage{
sleepData(data, sleep.def = c(5), bin = 30, t.cycle = 24)
}
\arguments{
\item{data}{Input data file. The input for this function must be the output of the function trimData(). See ??trimData().}

\item{sleep.def}{Definition of sleep. Traditionally, a single bout of sleep is defined as any duration of inactivity that is equal to or greater than 5-minutes. However, sometimes it may be of interest to examine longer bouts of sleep or specific bout durations; sleep.def allows users to change the definition of sleep. The default input is a single value vector of value 5. If users wish to analyse sleep only between 5 to 20 mins, the input must be c(5,20).}

\item{bin}{Intervals in which data are saved (in minutes). This defaults to 30. The value of bin cannot be lower than that of sleep.def.}

\item{t.cycle}{Define the period of the environmental cycle or a single day in hours. This defaults to 24.}
}
\value{
A \code{data.frame} with 33 columns (number of rows depends on number of days, and the input parameters of this function):
\describe{
\item{ZT}{ZT values starting at ZT00 (time at which light turns ON).}
\item{I1:I32}{Columns of binned sleep data (each column represents a single fly).}
}
}
\description{
Allows users to bin data sets into intervals of time different from the data collection interval. The input for this function must be the output of the trimData() function. The output of this function is a data frame. The first column of which stores Zeitgeber Time values (assuming that the start.time in the trimData() function was set at Zeitgeber Time 00). All subsequent columns have binned sleep data for each fly.
In a particular bin, sleep is calculated as the total minutes of inactivity equal to or greater than the defined threshold (sleep.def; typically, 5-minutes).
}
\examples{
td <- trimData(data = df, start.date = "19 Dec 20", start.time = "21:00",
n.days = 4, bin = 1, t.cycle = 24)
sd <- sleepData(data = td[,1:15])
}
