% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transitionProbs.R
\name{transitionProbs}
\alias{transitionProbs}
\title{Plot and generate data for transition frequencies between sleep stages}
\usage{
transitionProbs(data, n.days, photoperiod = 12)
}
\arguments{
\item{data}{Input data file. The input for this function must be the output of the function trimData(). See ??trimData().}

\item{n.days}{The number of cycles for which sleep stages must be visualized.}

\item{photoperiod}{This value determines the duration of photo-phase and scoto-phase of the 24-h day. Defaults to 12.}
}
\value{
A \code{list} with two items:
\describe{
\item{Plots}{A \code{plotly} \code{htmlwidget} with the Sankey diagram (representing the average transition percentages).}
\item{Data}{A \code{matrix} \code{array} with individual wise transition percentages.}
}
}
\description{
This function generates a sankey plot enabling the visualization of percentage of times transtions from various states of activity and sleep occur. This function also generates a data table to download individual values of these transition percentages. Sleep stages are defined as follows: 5 to 30-min as short sleep (light blue), 30 to 60-min as intermediate sleep (medium blue) and 60 to 720-min as deep sleep (dark blue). Activity is defined as the standard number of beam crosses. The input for this function must be the output of the trimData() function. The output of this function is a list. Note: At this moment, this works accurately only for 24-h days.
}
\examples{
\dontrun{
td <- trimData(data = df, start.date = "19 Dec 20", start.time = "21:00",
n.days = 2, bin = 1, t.cycle = 24)
tp <- transitionProbs(data = td, n.days = 1)
}
}
