% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_daymet.r
\name{merge_daymet}
\alias{merge_daymet}
\title{Merge Daymet data with a PhenoCam time series}
\usage{
merge_daymet(data, trim = FALSE, internal = TRUE, out_dir = tempdir())
}
\arguments{
\item{data}{a PhenoCam data file or data structure}

\item{trim}{logical, trim the daymet data to the length of the
PhenoCam time series or include the whole Daymet time series (1980-current).
(default = \code{FALSE})}

\item{internal}{return a data structure if given a file on disk
(\code{TRUE} / \code{FALSE} = default)}

\item{out_dir}{output directory where to store data (default = tempdir())}
}
\value{
A PhenoCam data structure or file which combines PhenoCam time series
data with Daymet based climate values (columns will be added).
}
\description{
Combine PhenoCam time series with matching climatological variables from
Daymet.
}
\examples{

\donttest{
# download demo data
download_phenocam(site = "harvard$",
                  veg_type = "DB",
                  roi_id = "1",
                  frequency = "3")

# merge data with daymet data
merge_daymet(paste0(tempdir(),"/harvard_DB_0001_3day.csv"))
}
}
\keyword{Daymet,}
\keyword{PhenoCam,}
\keyword{data}
\keyword{integration}
\keyword{series,}
\keyword{time}
