% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backval.R
\name{backval}
\alias{backval}
\title{backval}
\usage{
backval(y, t, w, Tn, minT = 5, nptperyear, ...)
}
\arguments{
\item{y}{Numeric vector, vegetation index time-series}

\item{t}{Numeric vector, \code{Date} variable}

\item{w}{(optional) Numeric vector, weights of \code{y}. If not specified,
weights of all \code{NA} values will be \code{wmin}, the others will be 1.0.}

\item{Tn}{Numeric vector, night temperature, default is null. If provided,
Tn is used to help divide ungrowing period, and then get background value in
ungrowing season (see details in \code{\link[phenofit:backval]{phenofit::backval()}}).}

\item{minT}{min temperature for growing season.}

\item{nptperyear}{Integer, number of images per year.}

\item{...}{Others will be ignored.}
}
\value{
back If back value is NA, it is impossible to extract phenology here.
}
\description{
Calculate backgroud values for vegetation index.
}
\details{
Night temperature Tn >= Tmin (default 5 degree) defined as raw growing season.
Background value is determined from two neighboring vegetation in raw growing
season by assuming that the background and vegetation abundance could remain
the same during a consecutive two yearperiod.
Details can be seen in Zhang et al., (2015).
}
\note{
This function only works in every growing season.
}
\references{
\enumerate{
\item Zhang, X., 2015. Reconstruction of a complete global time series of daily
vegetation index trajectory from long-term AVHRR data. Remote Sens. Environ.
156, 457–472. https://doi.org/10.1016/j.rse.2014.10.012. \cr
\item Zhang, Y., Xiao, X., Jin, C., Dong, J., Zhou, S., Wagle, P., Joiner,
J., Guanter, L., Zhang, Y., Zhang, G., Qin, Y., Wang, J., Moore, B., 2016.
Consistency between sun-induced chlorophyll fluorescence and gross primary
production of vegetation in North America. Remote Sens. Environ.
183, 154–169. https://doi.org/10.1016/j.rse.2016.05.015.
}
}
