% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_fFITs.R
\name{fFITs}
\alias{fFITs}
\alias{plot.fFITs}
\title{S3 class of multiple fine curve fittings object.}
\usage{
\method{plot}{fFITs}(x, method, ...)
}
\arguments{
\item{x}{Fine curve fitting object \code{\link[=fFITs]{fFITs()}} returned by
\code{\link[=curvefit]{curvefit()}}.}

\item{method}{Which fine curve fitting method to be extracted?}

\item{...}{ignored.}
}
\description{
plot curve fitting VI, gradient (first order difference D1), hessian (D2),
curvature (k) and the change rate of curvature(der.k)
}
\examples{
library(phenofit)
# simulate vegetation time-series
fFUN = doubleLog.Beck
par  = c( mn  = 0.1 , mx  = 0.7 , sos = 50 , rsp = 0.1 , eos = 250, rau = 0.1)

t    <- seq(1, 365, 8)
tout <- seq(1, 365, 1)
y <- fFUN(par, t)

methods <- c("AG", "Beck", "Elmore", "Gu", "Zhang") # "Klos" too slow
fFITs <- curvefit(y, t, tout, methods)

# plot
plot(fFITs)
}
\keyword{internal}
