#' Database of leatherback CMR in French Guiana
#' @title Database of leatherback CMR in French Guiana
#' @author Marc Girondot \email{marc.girondot@@u-psud.fr}
#' @docType data
#' @name outLR
#' @description Database of leatherback CMR in French Guiana
#' @references Rivalan, P., Godfrey, M.H., Prévot-Julliard, A.-C., 
#' Girondot, M., 2005. Maximum likelihood estimates of tag loss in 
#' leatherback sea turtles. Journal of Wildlife Management 69, 540-548.
#' @keywords datasets
#' @usage outLR
#' @examples
#' \dontrun{
#' library(phenology)
#' # Read a file with result
#' data(outLR)
#' data_f_21 <- Tagloss_format(outLR, model="21")
#' }
#' @format A dataframe with database of leatherback CMR in French Guiana
NULL
