% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solutes.data.r
\docType{data}
\name{phenylalanine.spct}
\alias{phenylalanine.spct}
\title{Molar spectral attenuation coefficient of phenylalanine}
\format{
A \code{solute_spct} object with 1993 rows and 2 variables
}
\usage{
phenylalanine.spct
}
\description{
A dataset containing the wavelengths at a 0.25 nm interval and the
  corresponding attenuation coefficients.
}
\details{
\itemize{ \item w.length (nm), range 222 to 720 nm. \item K.mole
(cm-1/M)}
}
\examples{
head(phenylalanine.spct)
summary(phenylalanine.spct)
solute_properties(phenylalanine.spct)
cat(comment(phenylalanine.spct))

}
\references{
\url{https://omlc.org/spectra/PhotochemCAD/html/073.html}

H. Du, R. A. Fuh, J. Li, A. Corkan, J. S. Lindsey, "PhotochemCAD: A
computer-aided design and research tool in photochemistry," Photochem.
Photobiol., 68, 141-142, 1998.

J. M. Dixon, M. Taniguchi and J. S. Lindsey "PhotochemCAD 2. A refined
program with accompanying spectral databases for photochemical calculations",
Photochem. Photobiol., 81, 212-213, 2005.
}
\seealso{
Other Spectral data examples: 
\code{\link{A.illuminant.spct}},
\code{\link{D65.illuminant.spct}},
\code{\link{Ler_leaf.spct}},
\code{\link{Ler_leaf_rflt.spct}},
\code{\link{Ler_leaf_trns.spct}},
\code{\link{Ler_leaf_trns_i.spct}},
\code{\link{black_body.spct}},
\code{\link{ccd.spct}},
\code{\link{clear.spct}},
\code{\link{clear_body.spct}},
\code{\link{filter_cps.mspct}},
\code{\link{green_leaf.spct}},
\code{\link{opaque.spct}},
\code{\link{photodiode.spct}},
\code{\link{polyester.spct}},
\code{\link{sun.daily.data}},
\code{\link{sun.daily.spct}},
\code{\link{sun.data}},
\code{\link{sun.spct}},
\code{\link{water.spct}},
\code{\link{white_body.spct}},
\code{\link{white_led.cps_spct}},
\code{\link{white_led.raw_spct}},
\code{\link{white_led.source_spct}},
\code{\link{yellow_gel.spct}}
}
\author{
Du et ql. (original data); Scott Prahl (included data).
}
\concept{Spectral data examples}
\keyword{datasets}
