% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/photon.ratio.r
\name{photon_ratio}
\alias{photon_ratio}
\title{Photo:photon ratio}
\usage{
photon_ratio(
  w.length,
  s.irrad,
  w.band.num = NULL,
  w.band.denom = NULL,
  unit.in = "energy",
  check.spectrum = TRUE,
  use.cached.mult = FALSE,
  use.hinges = getOption("photobiology.use.hinges", default = NULL)
)
}
\arguments{
\item{w.length}{numeric vector of wavelength (nm).}

\item{s.irrad}{numeric vector of spectral irradiances in
[\eqn{W\,m^{-2}\,nm^{-1}}{W m-2 nm-1}] or
[\eqn{mol\,s^{-1}\,sm^{-2}\,nm^{-1}}{mol s-1 m-2 nm-1}] as indicated by the
argument pased to \code{unit.in}.}

\item{w.band.num}{waveband object used to compute the numerator of the ratio.}

\item{w.band.denom}{waveband object used to compute the denominator of the ratio.}

\item{unit.in}{character Allowed values \code{"energy"}, and \code{"photon"},
or its alias \code{"quantum"}.}

\item{check.spectrum}{logical Flag telling whether to sanity check input data,
default is TRUE.}

\item{use.cached.mult}{logical Flag telling whether multiplier values should be
cached between calls.}

\item{use.hinges}{logical Flag indicating whether to insert "hinges" into the
spectral data before integration so as to reduce interpolation errors at
the boundaries of the wavebands.}
}
\value{
a single numeric value giving the unitless ratio.
}
\description{
This function gives the photon ratio between two given wavebands of a
radiation spectrum.
}
\note{
The default for both \code{w.band} parameters is a waveband covering
  the whole range of \code{w.length}.
}
\examples{
with(sun.data,
     photon_ratio(w.length, s.e.irrad, new_waveband(400,500), new_waveband(400,700)))

}
\seealso{
Other low-level functions operating on numeric vectors.: 
\code{\link{as_energy}()},
\code{\link{as_quantum_mol}()},
\code{\link{calc_multipliers}()},
\code{\link{div_spectra}()},
\code{\link{energy_irradiance}()},
\code{\link{energy_ratio}()},
\code{\link{insert_hinges}()},
\code{\link{integrate_xy}()},
\code{\link{interpolate_spectrum}()},
\code{\link{irradiance}()},
\code{\link{l_insert_hinges}()},
\code{\link{oper_spectra}()},
\code{\link{photon_irradiance}()},
\code{\link{photons_energy_ratio}()},
\code{\link{prod_spectra}()},
\code{\link{s_e_irrad2rgb}()},
\code{\link{split_energy_irradiance}()},
\code{\link{split_photon_irradiance}()},
\code{\link{subt_spectra}()},
\code{\link{sum_spectra}()},
\code{\link{trim_tails}()},
\code{\link{v_insert_hinges}()},
\code{\link{v_replace_hinges}()}
}
\concept{low-level functions operating on numeric vectors.}
