% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copy.attr.R
\name{subset_attributes}
\alias{subset_attributes}
\alias{subset_attributes.default}
\alias{subset_attributes.generic_spct}
\title{Subset the metadata attributes}
\usage{
subset_attributes(x, to.keep, ...)

\method{subset_attributes}{default}(x, to.keep, ...)

\method{subset_attributes}{generic_spct}(
  x,
  to.keep = character(),
  target.attributes = spct_attributes(class(x)[1]),
  ...
)
}
\arguments{
\item{x}{a generic_spct object.}

\item{to.keep}{character vector Indices to the spectra for
which attributes are to be extracted and retained.}

\item{...}{currently ignored}

\item{target.attributes}{character vector Names of attributes to be subset using
\code{which}.}
}
\value{
Named \code{list} of attribute values.
}
\description{
Method returning attributes of an object of class generic_spct or derived,
or of class waveband. Only attributes defined and/or set by package
'photobiology' for objects of the corresponding class are returned. Parameter
\code{which} can be used to subset each attribute when a generic_spct object
with multiple spectra in long form is subset.
}
\details{
The values in \code{which} are passed as argument to the extract
  operator only if the value of the attribute is a list of the same length
  as the logical vector passed as argument to \code{which}.
}
\section{Methods (by class)}{
\itemize{
\item \code{subset_attributes(default)}: default

\item \code{subset_attributes(generic_spct)}: generic_spct

}}
\seealso{
\code{\link{select_spct_attributes}}

Other measurement metadata functions: 
\code{\link{add_attr2tb}()},
\code{\link{getFilterProperties}()},
\code{\link{getHowMeasured}()},
\code{\link{getInstrDesc}()},
\code{\link{getInstrSettings}()},
\code{\link{getSoluteProperties}()},
\code{\link{getWhatMeasured}()},
\code{\link{getWhenMeasured}()},
\code{\link{getWhereMeasured}()},
\code{\link{get_attributes}()},
\code{\link{isValidInstrDesc}()},
\code{\link{isValidInstrSettings}()},
\code{\link{select_spct_attributes}()},
\code{\link{setFilterProperties}()},
\code{\link{setHowMeasured}()},
\code{\link{setInstrDesc}()},
\code{\link{setInstrSettings}()},
\code{\link{setSoluteProperties}()},
\code{\link{setWhatMeasured}()},
\code{\link{setWhenMeasured}()},
\code{\link{setWhereMeasured}()},
\code{\link{spct_attr2tb}()},
\code{\link{spct_metadata}()},
\code{\link{trimInstrDesc}()},
\code{\link{trimInstrSettings}()}
}
\concept{measurement metadata functions}
\keyword{internal}
