% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color.of.R
\name{color_of}
\alias{color_of}
\alias{color_of.default}
\alias{color_of.numeric}
\alias{color_of.list}
\alias{color_of.waveband}
\alias{color_of.source_spct}
\alias{color_of.source_mspct}
\alias{colour_of}
\alias{color}
\alias{fast_color_of_wl}
\alias{fast_color_of_wb}
\title{Color of an object}
\usage{
color_of(x, ...)

\method{color_of}{default}(x, ...)

\method{color_of}{numeric}(x, type = "CMF", chroma.type = type, ...)

\method{color_of}{list}(x, short.names = TRUE, type = "CMF", chroma.type = type, ...)

\method{color_of}{waveband}(x, short.names = TRUE, type = "CMF", chroma.type = type, ...)

\method{color_of}{source_spct}(x, type = "CMF", chroma.type = type, ...)

\method{color_of}{source_mspct}(x, ..., idx = "spct.idx")

colour_of(x, ...)

color(x, ...)

fast_color_of_wl(x, type = "CMF", ...)

fast_color_of_wb(x, type = "CMF", ...)
}
\arguments{
\item{x}{an R object.}

\item{...}{ignored (possibly used by derived methods).}

\item{type, chroma.type}{character telling whether "CMF", "CC", or "both" should be returned
for human vision, or an object of class \code{chroma_spct} for any other
trichromic visual system.}

\item{short.names}{logical indicating whether to use short or long names for
wavebands}

\item{idx}{character Name of the column with the names of the members of the
collection of spectra.}
}
\value{
A color definition in hexadecimal format as a \code{character} string
  of 7 characters, "#" followed by the red, blue, and green values in
  hexadecimal (scaled to 0 ... 255). In the case of the specialization for
  \code{list}, a list of such definitions is returned. In the case of a
  collection of spectra, a \code{data.frame} with one column with such
  definitions and by default an additional column with names of the spectra
  as index. In case of missing input the returned value is \code{NA}.
}
\description{
Equivalent RGB color of an object such as a spectrum, wavelength or waveband.
}
\section{Methods (by class)}{
\itemize{
\item \code{color_of(default)}: Default method (returns always "black").

\item \code{color_of(numeric)}: Method that returns Color definitions corresponding to
numeric values representing a wavelengths in nm.

\item \code{color_of(list)}: Method that returns Color of elements in a list.

\item \code{color_of(waveband)}: Color at midpoint of a \code{\link{waveband}} object.

\item \code{color_of(source_spct)}: 

\item \code{color_of(source_mspct)}: 

}}
\note{
The specialization of \code{color_of()} for \code{numeric} and function
  \code{fast_color_of_wl()} accept both positive and negative values in
  \code{x} as long as all values have the same sign. This makes its use in
  'ggspectra' simpler as the reverse scale transform changes the sign of the
  data. This should be considered a temporary fix.

When \code{x} is a list but not a waveband, if a method  \code{color_of}
  is not available for the class of each element of the list, then
  \code{color_of.default} will be called.

Function \code{fast_color_of_wl()} should be used only when high
  performance is needed. It speeds up performance by rounding the wavelength
  values in the numeric vector passed as argument to \code{x} and then
  retrieves the corresponding pre-computed color definitions if \code{type}
  is either \code{"CMF"} or \code{"CC"}. In other cases it falls-back to
  calling \code{color_of.numeric()}. Returned color definitions always have
  default names irrespective of names of \code{x}, which is different from
  the behavior of \code{color_of()} methods.

  Function \code{fast_color_of_wb()} accepts waveband objects and lists of
  waveband objects. If all wavebands are narrow, it issues a vectotized
  call to \code{fast_color_of_wl()} with a vector of waveband midpoint
  wavelengths.
}
\section{Deprecated}{
 Use of color() is deprecated as this wrapper function
  may be removed in future versions of the package because of name clashes.
  Use color_of() instead.
}

\examples{
wavelengths <- c(300, 420, 500, 600, NA) # nanometres
color_of(wavelengths)
color_of(waveband(c(300,400)))
color_of(list(blue = waveband(c(400,480)), red = waveband(c(600,700))))
color_of(numeric())
color_of(NA_real_)

color_of(sun.spct)

}
