% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mspct.mean.r
\name{s_mean}
\alias{s_mean}
\alias{s_mean.default}
\alias{s_mean.generic_spct}
\alias{s_mean.source_mspct}
\alias{s_mean.response_mspct}
\alias{s_mean.filter_mspct}
\alias{s_mean.reflector_mspct}
\alias{s_mean.calibration_mspct}
\alias{s_mean.cps_mspct}
\alias{s_mean.raw_mspct}
\title{Mean from collection of spectra}
\usage{
s_mean(x, trim, na.rm, ...)

\method{s_mean}{default}(x, trim = 0, na.rm = FALSE, ...)

\method{s_mean}{generic_spct}(x, trim = 0, na.rm = FALSE, ...)

\method{s_mean}{source_mspct}(x, trim = 0, na.rm = FALSE, ...)

\method{s_mean}{response_mspct}(x, trim = 0, na.rm = FALSE, ...)

\method{s_mean}{filter_mspct}(x, trim = 0, na.rm = FALSE, ...)

\method{s_mean}{reflector_mspct}(x, trim = 0, na.rm = FALSE, ...)

\method{s_mean}{calibration_mspct}(x, trim = 0, na.rm = FALSE, ...)

\method{s_mean}{cps_mspct}(x, trim = 0, na.rm = FALSE, ...)

\method{s_mean}{raw_mspct}(x, trim = 0, na.rm = FALSE, ...)
}
\arguments{
\item{x}{An R object.}

\item{trim}{numeric The fraction (0 to 0.5) of observations to be trimmed
from each end of x before the mean is computed. Values of trim outside 
that range are taken as the nearest endpoint.}

\item{na.rm}{logical A value indicating whether NA values should be stripped
before the computation proceeds.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
If \code{x} is a collection spectral of objects, such as a
  \code{"filter_mspct"} object, the returned object is of same class as the
  members of the collection, such as \code{"filter_spct"}, containing the
  summary spectrum, with variables with names tagged for summaries other
  than mean or median.
}
\description{
Method to compute the "parallel" mean of values across members of a
collection of spectra or of a spectral object containing multiple spectra in
long form.
}
\details{
Method specializations compute the mean at each wavelength across a
  group of spectra stored in an object of one of the classes defined in
  package 'photobiolgy'. Trimming of extreme values is
  possible (trimmed mean) and omission of NAs is done separately at each
  wavelength. Interpolation is not applied, so all spectra in \code{x} must
  share the same set of wavelengths. An error is triggered if this condition
  is nor fulfilled.
}
\section{Methods (by class)}{
\itemize{
\item \code{s_mean(default)}: 

\item \code{s_mean(generic_spct)}: 

\item \code{s_mean(source_mspct)}: 

\item \code{s_mean(response_mspct)}: 

\item \code{s_mean(filter_mspct)}: 

\item \code{s_mean(reflector_mspct)}: 

\item \code{s_mean(calibration_mspct)}: 

\item \code{s_mean(cps_mspct)}: 

\item \code{s_mean(raw_mspct)}: 

}}
\note{
Objects of classes \code{raw_spct} and \code{cps_spct} can contain data
  from multiple scans in multiple variables or "columns". The methods accept
  as arguments objects of these classes only if spectra contain data for a
  single spectrometer scan. In the case of \code{cps_spct} objects, a single
  column can also contain data from multiple scans spliced into a single
  variable.
}
\examples{
s_mean(sun_evening.mspct)

}
\seealso{
See \code{\link[base]{mean}} for the \code{mean()} method used for
  the computations.
}
