% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zmspct.classes.R
\name{as.filter_mspct}
\alias{as.filter_mspct}
\alias{as.filter_mspct.default}
\alias{as.filter_mspct.data.frame}
\alias{as.filter_mspct.filter_spct}
\alias{as.filter_mspct.list}
\alias{as.filter_mspct.matrix}
\title{Coerce to a collection-of-spectra}
\usage{
as.filter_mspct(x, ...)

\method{as.filter_mspct}{default}(x, ...)

\method{as.filter_mspct}{data.frame}(x, Tfr.type = c("total", "internal"), strict.range = TRUE, ...)

\method{as.filter_mspct}{filter_spct}(x, ...)

\method{as.filter_mspct}{list}(
  x,
  Tfr.type = c("total", "internal"),
  strict.range = TRUE,
  ...,
  ncol = 1,
  byrow = FALSE
)

\method{as.filter_mspct}{matrix}(
  x,
  w.length,
  spct.data.var = "Tfr",
  multiplier = 1,
  byrow = NULL,
  spct.names = "spct_",
  ...
)
}
\arguments{
\item{x}{a list of spectral objects or a list of objects such as data frames
that can be converted into spectral objects.}

\item{...}{passed to individual spectrum object constructor}

\item{Tfr.type}{a character string, either "total" or "internal"}

\item{strict.range}{logical Flag indicating how off-range values are handled}

\item{ncol}{integer Number of 'virtual' columns in data}

\item{byrow}{logical If \code{ncol > 1} how to read in the data}

\item{w.length}{numeric A vector of wavelengthvalues sorted in strictly
ascending order (nm).}

\item{spct.data.var}{character The name of the variable that will contain the
spectral data. This indicates what physical quantity is stored in the
matrix and the units of expression used.}

\item{multiplier}{numeric A multiplier to be applied to the values in
\code{x} to do unit or scale conversion.}

\item{spct.names}{character Vector of names to be assigned to collection
members, either of length 1, or with length equal to the number of spectra.}
}
\value{
A copy of \code{x} converted into a \code{filter_mspct} object.
}
\description{
Return a copy of an R object with its class set to a given type
  of spectrum.
}
\section{Methods (by class)}{
\itemize{
\item \code{as.filter_mspct(default)}: 

\item \code{as.filter_mspct(data.frame)}: 

\item \code{as.filter_mspct(filter_spct)}: 

\item \code{as.filter_mspct(list)}: 

\item \code{as.filter_mspct(matrix)}: 

}}
\note{
When \code{x} is a square matrix an explicit argument is needed for
  \code{byrow} to indicate how data in \code{x} should be read. In every case
  the length of the \code{w.length} vector must match one of the dimensions
  of \code{x}.
}
\seealso{
Other Coercion methods for collections of spectra: 
\code{\link{as.calibration_mspct}()},
\code{\link{as.chroma_mspct}()},
\code{\link{as.cps_mspct}()},
\code{\link{as.generic_mspct}()},
\code{\link{as.object_mspct}()},
\code{\link{as.raw_mspct}()},
\code{\link{as.reflector_mspct}()},
\code{\link{as.response_mspct}()},
\code{\link{as.solute_mspct}()},
\code{\link{as.source_mspct}()},
\code{\link{split2mspct}()},
\code{\link{subset2mspct}()}
}
\concept{Coercion methods for collections of spectra}
