% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.classes.r
\name{convertTfrType}
\alias{convertTfrType}
\title{Convert the "Tfr.type" attribute}
\usage{
convertTfrType(x, Tfr.type = NULL)
}
\arguments{
\item{x}{a \code{filter_spct}, \code{object_spct}, \code{filter_mspct}
or \code{object_mspct} object.}

\item{Tfr.type}{character One of \code{"internal"} or \code{"total"}.}
}
\value{
\code{x} if possible, with the value of the \code{"Tfr.type"}
  attribute
  modified and the values stored in the \code{Tfr} variable converted to the
  new quantity.
}
\description{
Function to set the \code{"Tfr.type"} attribute and simultaneously convert
the spectral data to correspond to the new type.
}
\details{
Internal transmittance, \eqn{\tau}, uses as reference the light
  entering the object while total transmittance, \eqn{T}, takes the incident
  light as reference. The conversion is possible only if total reflectance,
  \eqn{\rho}, is known. Either as spectral
  data in an \code{object_spct} object, a \code{filter_spct} object that is
  "under-the-hood" an \code{object_spct}, or if a fixed reflectance factor
  applicable to all wavelengths is stored in the \code{filter.properties}
  attribute of the \code{filter_spct} object.

  Conversions are computed as:

\deqn{\tau = \frac{T - \rho}{1 - \rho}}

and

\deqn{T = \tau * (1 - \rho) + \rho}

  For the conversion to take place the object passed as argument to \code{x},
  must contain a column with transmittance data, named \code{Tfr}. Any
  necessary conversion from absorbance \code{A} or from \code{Afr} into
  transmittance, must be done before calling \code{convertTfrType()}.
}
\note{
if \code{x} is not a \code{filter_spct} object, \code{x} is returned
  unchanged. If \code{x} does not have the \code{"filter.properties"}
  attribute set if it is missing data, \code{x} is returned with
  \code{Tfr} set to \code{NA} values.
}
\examples{
getTfrType(polyester.spct)
filter_properties(polyester.spct)
convertTfrType(polyester.spct, Tfr.type = "internal")

}
\seealso{
\code{\link{setTfrType}}, \code{\link{filter_spct}}
}
