% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.quantum.R
\name{as_quantum}
\alias{as_quantum}
\title{Convert spectral energy irradiance into spectral photon irradiance}
\usage{
as_quantum(w.length, s.e.irrad)
}
\arguments{
\item{w.length}{numeric Vector of wavelengths (nm)}

\item{s.e.irrad}{numeric Corresponding vector of spectral (energy)
irradiances}
}
\value{
A numeric array of spectral photon irradiances
}
\description{
For example an spectrum [W m-2 nm-1] is converted into a spectrum [s-1 m-2
nm-1]
}
\examples{
with(sun.data, as_quantum(w.length, s.e.irrad))

}
\seealso{
Other quantity conversion functions: \code{\link{A2T}},
  \code{\link{T2A}}, \code{\link{as_energy}},
  \code{\link{as_quantum_mol}},
  \code{\link{e2qmol_multipliers}},
  \code{\link{e2quantum_multipliers}}, \code{\link{e2q}},
  \code{\link{q2e}}
}
