% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.operators.R
\name{q2e}
\alias{q2e}
\alias{q2e.default}
\alias{q2e.source_spct}
\alias{q2e.response_spct}
\alias{q2e.source_mspct}
\alias{q2e.response_mspct}
\title{Convert photon-based quantities into energy-based quantities}
\usage{
q2e(x, action, byref, ...)

\method{q2e}{default}(x, action = "add", byref = FALSE, ...)

\method{q2e}{source_spct}(x, action = "add", byref = FALSE, ...)

\method{q2e}{response_spct}(x, action = "add", byref = FALSE, ...)

\method{q2e}{source_mspct}(x, action = "add", byref = FALSE, ...)

\method{q2e}{response_mspct}(x, action = "add", byref = FALSE, ...)
}
\arguments{
\item{x}{an R object}

\item{action}{a character string}

\item{byref}{logical indicating if new object will be created by reference or by copy of x}

\item{...}{not used in current version}
}
\description{
Function that coverts spectral photon irradiance (molar) into spectral energy irradiance.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default method

\item \code{source_spct}: Method for spectral irradiance

\item \code{response_spct}: Method for spectral responsiveness

\item \code{source_mspct}: Method for collections of (light) source spectra

\item \code{response_mspct}: Method for collections of response spectra
}}

\seealso{
Other quantity conversion functions: \code{\link{A2T}},
  \code{\link{T2A}}, \code{\link{as_energy}},
  \code{\link{as_quantum_mol}}, \code{\link{as_quantum}},
  \code{\link{e2qmol_multipliers}},
  \code{\link{e2quantum_multipliers}}, \code{\link{e2q}}
}
