% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.new.r
\name{merge2object_spct}
\alias{merge2object_spct}
\title{Merge into object_spct}
\usage{
merge2object_spct(x, y, by = "w.length", ...,
  w.length.out = x[["w.length"]], Tfr.type.out = "total")
}
\arguments{
\item{x, y}{a filter_spct object and a reflector_spct object.}

\item{by}{a vector of shared column names in \code{x} and \code{y} to merge
on; \code{by} defaults to \code{w.length}.}

\item{...}{other arguments passed to \code{dplyr::inner_join()}}

\item{w.length.out}{numeric array of wavelengths to be used for the returned
object (nm).}

\item{Tfr.type.out}{character string indicating whether transmittance
values in the returned object should be expressed as "total" or "internal".
This applies only to the case when an object_spct is returned.}
}
\value{
An object_spct is returned as the result of merging a filter_spct and
  a reflector_spct object.
}
\description{
Merge a filter_spct with a reflector_spct returning an object_spct object,
even if wavelength values are missmatched.
}
\note{
If a numeric vector is supplied as argument for \code{w.length.out},
  the two spectra are interpolated to the new wavelength values before
  merging. The default argument for \code{w.length.out} is x[[w.length]].
}
\seealso{
\code{\link[dplyr]{join}}
}
