% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split.energy.irradiance.r
\name{split_energy_irradiance}
\alias{split_energy_irradiance}
\title{Energy irradiance for split spectrum regions}
\usage{
split_energy_irradiance(w.length, s.irrad, cut.w.length = range(w.length),
  unit.in = "energy", scale = "absolute", check.spectrum = TRUE,
  use.cached.mult = FALSE, use.hinges = getOption("photobiology.use.hinges",
  default = NULL))
}
\arguments{
\item{w.length}{numeric Vector of wavelengths (nm)}

\item{s.irrad}{numeric Corresponding vector of spectral (energy) irradiances
(W m-2 nm-1)}

\item{cut.w.length}{numeric Vector of wavelengths (nm)}

\item{unit.in}{character A string with allowed values "energy", and "photon",
or its alias "quantum"}

\item{scale}{character A string indicating the scale used for the returned
values ("absolute", "relative", "percent")}

\item{check.spectrum}{logical indicating whether to sanity check input data,
default is TRUE}

\item{use.cached.mult}{logical indicating whether multiplier values should be
cached between calls}

\item{use.hinges}{logical indicating whether to use hinges to reduce
interpolation errors}
}
\value{
a numeric array of irradiances with no change in scale factor: [W m-2
  nm-1] -> [mol s-1 m-2] or relative values (fraction of one) if scale =
  "relative" or scale = "percent"
}
\description{
This function returns the energy irradiance for a series of contiguous
wavebands from a radiation-source spectrum. The returned values can be either
absolute or relative to their sum.
}
\note{
The last three parameters control speed optimizations. The defaults
  should be suitable in mosts cases. If you set \code{check.spectrum=FALSE}
  then you should call \code{\link{check_spectrum}} at least once for your
  spectrum before using any of the other functions. If you will use
  repeatedly the same SWFs on many spectra measured at exactly the same
  wavelengths you may obtain some speed up by setting
  \code{use.cached.mult=TRUE}. However, be aware that you are responsible for
  ensuring that the wavelengths are the same in each call, as the only test
  done is for the length of the \code{w.length} vector.
}
\examples{
with(sun.data,
     split_energy_irradiance(w.length, s.e.irrad,
                             cut.w.length = c(300, 400, 500, 600, 700)))
}
\seealso{
Other split a spectrum into regions functions: \code{\link{split_irradiance}},
  \code{\link{split_photon_irradiance}}
}
