% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.irrad.r
\name{e_irrad}
\alias{e_irrad}
\alias{e_irrad.default}
\alias{e_irrad.source_spct}
\alias{e_irrad.source_mspct}
\title{Energy irradiance}
\usage{
e_irrad(spct, w.band, quantity, time.unit, wb.trim, use.cached.mult, use.hinges,
  allow.scaled, ...)

\method{e_irrad}{default}(spct, w.band, quantity, time.unit, wb.trim,
  use.cached.mult, use.hinges, allow.scaled, ...)

\method{e_irrad}{source_spct}(spct, w.band = NULL, quantity = "total",
  time.unit = NULL, wb.trim = getOption("photobiology.waveband.trim",
  default = TRUE), use.cached.mult = getOption("photobiology.use.cached.mult",
  default = FALSE), use.hinges = NULL, allow.scaled = !quantity \%in\%
  c("average", "mean", "total"), ...)

\method{e_irrad}{source_mspct}(spct, w.band = NULL, quantity = "total",
  time.unit = NULL, wb.trim = getOption("photobiology.waveband.trim",
  default = TRUE), use.cached.mult = getOption("photobiology.use.cached.mult",
  default = FALSE), use.hinges = NULL, allow.scaled = !quantity \%in\%
  c("average", "mean", "total"), ..., attr2tb = NULL,
  idx = !is.null(names(spct)), .parallel = FALSE, .paropts = NULL)
}
\arguments{
\item{spct}{an R object.}

\item{w.band}{a list of \code{waveband} objects or a \code{waveband} object.}

\item{quantity}{character string One of "total", "average" or "mean",
"contribution", "contribution.pc", "relative" or "relative.pc".}

\item{time.unit}{character or lubridate::duration object.}

\item{wb.trim}{logical if TRUE wavebands crossing spectral data boundaries
are trimmed, if FALSE, they are discarded.}

\item{use.cached.mult}{logical indicating whether multiplier values should be
cached between calls.}

\item{use.hinges}{logical Flag indicating whether to insert "hinges" into the
spectral data before integration so as to reduce interpolation errors at
the boundaries of the wavebands.}

\item{allow.scaled}{logical indicating whether scaled or normalized spectra
as argument to spct are flagged as an error.}

\item{...}{other arguments (possibly used by derived methods).}

\item{attr2tb}{character vector, see \code{\link{add_attr2tb}} for the syntax for \code{attr2tb} passed as is to formal parameter \code{col.names}.}

\item{idx}{logical whether to add a column with the names of the elements of
spct}

\item{.parallel}{if TRUE, apply function in parallel, using parallel backend
provided by foreach}

\item{.paropts}{a list of additional options passed into the foreach function
when parallel computation is enabled. This is important if (for example)
your code relies on external data or packages: use the .export and
.packages arguments to supply them so that all cluster nodes have the
correct environment set up for computing.}
}
\value{
A named \code{numeric} vector in the case of methods for individual
  spectra, with one value for each \code{waveband} passed to parameter
  \code{w.band}. A \code{data.frame} in the case of collections of spectra,
  containing one column for each \code{waveband} object, an index column with
  the names of the spectra, and optionally additional columns with metadata
  values retrieved from the attributes of the member spectra.

  By default values are only integrated, but depending on the argument passed
  to parameter \code{quantity} they can be re-expressed as relative fractions
  or percentages. In the case of vector output, \code{names} attribute is set
  to the name of the corresponding waveband unless a named list is supplied
  in which case the names of the list members are used. The  time.unit
  attribute is copied from the spectrum object to the output. Units are as
  follows: If units are absolute and time.unit is second, [W m-2 nm-1] -> [W
  m-2] If time.unit is day, [J d-1 m-2 nm-1] -> [J m-2]; if units are
  relative, fraction of one or percent.
}
\description{
Energy irradiance for one or more wavebands of a light source spectrum.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default for generic function

\item \code{source_spct}: Calculates energy irradiance from a \code{source_spct}
object.

\item \code{source_mspct}: Calculates energy irradiance from a
\code{source_mspct} object.
}}

\note{
The last two parameters control speed optimizations. The defaults
  should be suitable in most cases. If you will use repeatedly the same SWFs
  on many spectra measured at exactly the same wavelengths you may obtain
  some speed up by setting \code{use.cached.mult=TRUE}. However, be aware
  that you are responsible for ensuring that the wavelengths are the same in
  each call, as the only test done is for the length of the \code{w.length}
  vector.
}
\examples{
e_irrad(sun.spct, waveband(c(400,700)))
e_irrad(sun.spct, split_bands(c(400,700), length.out = 3))
e_irrad(sun.spct, split_bands(c(400,700), length.out = 3),
        quantity = "total")
e_irrad(sun.spct, split_bands(c(400,700), length.out = 3),
        quantity = "average")
e_irrad(sun.spct, split_bands(c(400,700), length.out = 3),
        quantity = "relative")
e_irrad(sun.spct, split_bands(c(400,700), length.out = 3),
        quantity = "relative.pc")
e_irrad(sun.spct, split_bands(c(400,700), length.out = 3),
        quantity = "contribution")
e_irrad(sun.spct, split_bands(c(400,700), length.out = 3),
        quantity = "contribution.pc")

}
\seealso{
Other irradiance functions: \code{\link{e_fluence}},
  \code{\link{fluence}}, \code{\link{irrad}},
  \code{\link{q_fluence}}, \code{\link{q_irrad}}
}
