% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.irrad.r
\name{irrad}
\alias{irrad}
\alias{irrad.default}
\alias{irrad.source_spct}
\alias{irrad.source_mspct}
\title{Irradiance}
\usage{
irrad(spct, w.band, unit.out, quantity, time.unit, wb.trim, use.cached.mult,
  use.hinges, allow.scaled, ...)

\method{irrad}{default}(spct, w.band, unit.out, quantity, time.unit, wb.trim,
  use.cached.mult, use.hinges, allow.scaled, ...)

\method{irrad}{source_spct}(spct, w.band = NULL,
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  quantity = "total", time.unit = NULL,
  wb.trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.cached.mult = getOption("photobiology.use.cached.mult", default =
  FALSE), use.hinges = getOption("photobiology.use.hinges"),
  allow.scaled = !quantity \%in\% c("average", "mean", "total"), ...)

\method{irrad}{source_mspct}(spct, w.band = NULL,
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  quantity = "total", time.unit = NULL,
  wb.trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.cached.mult = getOption("photobiology.use.cached.mult", default =
  FALSE), use.hinges = NULL, allow.scaled = !quantity \%in\% c("average",
  "mean", "total"), ..., attr2tb = NULL, idx = !is.null(names(spct)),
  .parallel = FALSE, .paropts = NULL)
}
\arguments{
\item{spct}{an R object.}

\item{w.band}{waveband or list of waveband objects The waveband(s) determine
the region(s) of the spectrum that are summarized.}

\item{unit.out}{character string with allowed values "energy", and "photon",
or its alias "quantum".}

\item{quantity}{character string One of "total", "average" or "mean",
"contribution", "contribution.pc", "relative" or "relative.pc".}

\item{time.unit}{character or lubridate::duration object.}

\item{wb.trim}{logical if TRUE wavebands crossing spectral data boundaries
are trimmed, if FALSE, they are discarded.}

\item{use.cached.mult}{logical indicating whether multiplier values should be
cached between calls.}

\item{use.hinges}{logical Flag indicating whether to insert "hinges" into the
spectral data before integration so as to reduce interpolation errors at
the boundaries of the wavebands.}

\item{allow.scaled}{logical indicating whether scaled or normalized spectra
as argument to spct are flagged as an error}

\item{...}{other arguments (possibly ignored)}

\item{attr2tb}{character vector, see \code{\link{add_attr2tb}} for the syntax for \code{attr2tb} passed as is to formal parameter \code{col.names}.}

\item{idx}{logical whether to add a column with the names of the elements of
spct}

\item{.parallel}{if TRUE, apply function in parallel, using parallel backend
provided by foreach}

\item{.paropts}{a list of additional options passed into the foreach function
when parallel computation is enabled. This is important if (for example)
your code relies on external data or packages: use the .export and
.packages arguments to supply them so that all cluster nodes have the
correct environment set up for computing.}
}
\value{
A named \code{numeric} vector in the case of methods for individual
  spectra, with one value for each \code{waveband} passed to parameter
  \code{w.band}. A \code{data.frame} in the case of collections of spectra,
  containing one column for each \code{waveband} object, an index column with
  the names of the spectra, and optionally additional columns with metadata
  values retrieved from the attributes of the member spectra.

  By default values are only integrated, but depending on the argument passed
  to parameter \code{quantity} they can be re-expressed as relative fractions
  or percentages. In the case of vector output, \code{names} attribute is set
  to the name of the corresponding waveband unless a named list is supplied
  in which case the names of the list members are used. The \code{time.unit}
  attribute is copied from the spectrum object to the output. Units are as
  follows: If time.unit is second, [W m-2 nm-1] -> [mol s-1 m-2] or [W m-2
  nm-1] -> [W m-2] If time.unit is day, [J d-1 m-2 nm-1] -> [mol d-1 m-2] or
  [J d-1 m-2 nm-1] -> [J m-2]
}
\description{
This function returns the irradiance for a given waveband of a light source
spectrum.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default for generic function

\item \code{source_spct}: Calculates irradiance from a \code{source_spct}
object.

\item \code{source_mspct}: Calculates irradiance from a \code{source_mspct}
object.
}}

\note{
Formal parameter \code{allow.scaled} is used internally for calculation
  of ratios, as rescaling and normalization do not invalidate the calculation
  of ratios.

The last two parameters control speed optimizations. The defaults
  should be suitable in most cases. If you will use repeatedly the same SWFs
  on many spectra measured at exactly the same wavelengths you may obtain
  some speed up by setting \code{use.cached.mult=TRUE}. However, be aware
  that you are responsible for ensuring that the wavelengths are the same in
  each call, as the only test done is for the length of the \code{w.length}
  vector.
}
\examples{
irrad(sun.spct, waveband(c(400,700)))
irrad(sun.spct, waveband(c(400,700)), "energy")
irrad(sun.spct, waveband(c(400,700)), "photon")
irrad(sun.spct, split_bands(c(400,700), length.out = 3))
irrad(sun.spct, split_bands(c(400,700), length.out = 3), quantity = "total")
irrad(sun.spct, split_bands(c(400,700), length.out = 3), quantity = "average")
irrad(sun.spct, split_bands(c(400,700), length.out = 3), quantity = "relative")
irrad(sun.spct, split_bands(c(400,700), length.out = 3), quantity = "relative.pc")
irrad(sun.spct, split_bands(c(400,700), length.out = 3), quantity = "contribution")
irrad(sun.spct, split_bands(c(400,700), length.out = 3), quantity = "contribution.pc")

}
\seealso{
Other irradiance functions: \code{\link{e_fluence}},
  \code{\link{e_irrad}}, \code{\link{fluence}},
  \code{\link{q_fluence}}, \code{\link{q_irrad}}
}
