% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zmspct.classes.R
\name{as.source_mspct}
\alias{as.source_mspct}
\alias{as.source_mspct.default}
\alias{as.source_mspct.data.frame}
\alias{as.source_mspct.source_spct}
\alias{as.source_mspct.list}
\alias{as.source_mspct.matrix}
\title{Coerce to a collection-of-spectra}
\usage{
as.source_mspct(x, ...)

\method{as.source_mspct}{default}(x, ...)

\method{as.source_mspct}{data.frame}(x, time.unit = c("second", "day",
  "exposure"), bswf.used = c("none", "unknown"),
  strict.range = getOption("photobiology.strict.range", default = FALSE), ...)

\method{as.source_mspct}{source_spct}(x, ...)

\method{as.source_mspct}{list}(x, time.unit = c("second", "day", "exposure"),
  bswf.used = c("none", "unknown"),
  strict.range = getOption("photobiology.strict.range", default = FALSE), ...,
  ncol = 1, byrow = FALSE)

\method{as.source_mspct}{matrix}(x, w.length, spct.data.var = "s.e.irrad",
  multiplier = 1, byrow = NULL, spct.names = "spct_", ...)
}
\arguments{
\item{x}{a list of spectral objects or a list of objects such as data frames
that can be converted into spectral objects.}

\item{...}{passed to individual spectrum object constructor}

\item{time.unit}{character A string, "second", "day" or "exposure"}

\item{bswf.used}{character}

\item{strict.range}{logical Flag indicating how off-range values are handled}

\item{ncol}{integer Number of 'virtual' columns in data}

\item{byrow}{logical If \code{ncol > 1} how to read in the data}

\item{w.length}{numeric A vector of wavelengthvalues sorted in strictly ascending
order (nm).}

\item{spct.data.var}{character The name of the variable that will contain the
spectral data. This indicates what physical quantity is stored in the matrix
and the units of expression used.}

\item{multiplier}{numeric A multiplier to be applied to the values in \code{x} to do
unit or scale conversion.}

\item{spct.names}{character Vector of names to be assigned to collection members,
either of length 1, or with length equal to the number of spectra.}
}
\value{
A copy of \code{x} converted into a \code{source_mspct} object.
}
\description{
Return a copy of an R object with its class set to a given type
  of spectrum.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: 

\item \code{data.frame}: 

\item \code{source_spct}: 

\item \code{list}: 

\item \code{matrix}: 
}}

\note{
When \code{x} is a square matrix an explicit argument is needed for
  \code{byrow} to indicate how data in \code{x} should be read. In every case
  the length of the \code{w.length} vector must match one of the dimensions
  of \code{x}.
}
\seealso{
Other Coercion methods for collections of spectra: \code{\link{as.calibration_mspct}},
  \code{\link{as.chroma_mspct}},
  \code{\link{as.cps_mspct}},
  \code{\link{as.filter_mspct}},
  \code{\link{as.generic_mspct}},
  \code{\link{as.object_mspct}},
  \code{\link{as.raw_mspct}},
  \code{\link{as.reflector_mspct}},
  \code{\link{as.response_mspct}},
  \code{\link{split2mspct}}, \code{\link{subset2mspct}}
}
