#' @title Skye-Instruments Sensors
#'
#' @description A vector of indeces for stracting subsets of spectra from the
#' \code{\link{sensors.mspct}} object.
#'
#' @format A character vector of members of the collection of spctra.
#'
#' @docType data
#' @keywords datasets
#'
#' @details
#' Skye PAR quantum Sensor SKP215, Skye PAR energy sensor SKE510, Skye Lux
#' sensor SKL310, Skye PAR 'Special' Sensor SKP210, Skye PAR quantum Sensor
#' SKP215, Skye 660/730 Sensor (Red/Far Red) Sensor SKR110 (red and far-red
#' channels), Skye Pyranometer Sensor SKS1110, Skye UV-A Sensor Sensor SKU421,
#' Skye UV-A Sensor Sensor SKU421 V. 3, Skye UV-B Sensor Sensor SKU430 V. 3,
#' Skye UVI Sensor Sensor SKU440 V. 3.
#'
#' Manufacturer: Skye Instruments, Llandrindod Wells, Powys, UK
#' \url{http://www.skyeinstruments.com/}
#'
#' @note
#' Spectral data digitized from figures in manufacturer's manuals.
#' These are typical measured data, and for specific sensor units the
#' calibration data supplied with the sensor must be used as individual
#' may differ in their spectral response. Furthermore, the digigitizing
#' process from figures with a linear scale is prone to errors, which
#' are specially noticeable in regions of low responsivity.
#'
#' @references
#' Manufacturer's brochure for 'SKP215' dated 2007-10-03.
#' Manufacturer's brochure for 'SKP510' dated 2007-10-02.
#' Manufacturer's brochure for 'SKL310' dated 2007-10-09
#' Manufacturer's brochure for 'SKP210' dated 2007-10-03
#' Manufacturer's brochure for 'Skye 660/730 Sensor (Red/Far Red) Sensor SKR110' dated 2007-10-09
#' Manufacturer's brochure 'Skye Pyranometer Sensor SKS1110' dated 2009-08-19
#' Manufacturer's 'UV-A, UV-B & UV-I Sensors' Manual, Iss. 1.1
#' Manufacturer's 'SKU 421 UVA Sensor' V. 3 brochure, not dated, dowloaded on 2015-01-24
#' Manufacturer's 'SKU 430 UVB Sensor' V. 3 brochure, not dated, dowloaded on 2015-01-24
#' Manufacturer's 'SKU 440 UV Index Sensor' V. 3 brochure, not dated, dowloaded on 2015-01-24
#'
#' KJ McCree. The action spectrum, absorbance and quantum yield of
#' photosynthesis in crop plants. Agricultural Meteorology. 1971/72
#' Vol 9, pp 191-216
#'
#' @examples
#' skye_sensors
#'
"skye_sensors"

