% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/photobiologysensors.r
\docType{package}
\name{photobiologySensors-package}
\alias{photobiologySensors}
\alias{photobiologySensors-package}
\title{photobiologySensors: Spectral Response Data for Light Sensors}
\description{
Spectral response data for broadband ultraviolet and visible
radiation sensors. Different data sources were used: author-supplied data
from scientific research papers, sensor-manufacturer supplied data, and
published sensor specifications. Part of the 'r4photobiology' suite
Aphalo P. J. (2015) <doi:10.19232/uv4pb.2015.1.14>.
}
\details{
Data for response spectra for different types of broadband sensors.
The package contains one collection of spectra for different broadband
sensors.

In addition to the spectra the package provides character vectors of names
to be used as indexes to subset groups of spectra. In many cases spectral
data are normalized to spectral energy responsieness equal to one at the
wavelength of maximum spectral energy response (peak sensitivity).

The data in this package are not original. Some have been provided by
authors of scientific publications and manufacturers. However, most of
the spectra have been digitised from manufacturer's brochures and manuals
available on web sites.
}
\section{Warning!}{

The spectral data included in this package are not all based on supplier's
specifications and are only for information. The exact response spectrum
depends to some extent on testing conditions, but more importantly varies among
individual sensor units. Spectral specifications are usually given as typical
values. All the sensors for which data are presented here need periodic
calibration. In other words, the data provided here are not a substitute
for actual calibration under measuring conditions for each individual sensor
unit. For less demanding situations like roughly assessing the suitability
of sensors or the need or not of a transfer calibration, the data are good
enough. They can be especially useful in teaching.
}

\examples{
library(photobiology)
library(photobiologyWavebands)
library(ggspectra)

names(sensors.mspct)

licor_sensors
par_sensors
intersect(par_sensors, licor_sensors)

photon_as_default()

response(sensors.mspct$LI_190, w.band = PAR(), quantity = "contribution.pc")

plot(sensors.mspct$LI_190, w.band = PAR(), label.qty = "contribution.pc")

}
\seealso{
Useful links:
\itemize{
  \item \url{http://www.r4photobiology.info}
  \item \url{https://bitbucket.org/aphalo/photobiologysensors}
  \item Report bugs at \url{https://bitbucket.org/aphalo/photobiologysensors/issues}
}

}
\author{
\strong{Maintainer}: Pedro J. Aphalo \email{pedro.aphalo@helsinki.fi} (https://orcid.org/0000-0003-3385-972X)

}
