% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/far.red.r
\name{Far_red}
\alias{Far_red}
\title{Constructor of FR waveband}
\usage{
Far_red(std = "ISO")
}
\arguments{
\item{std}{a character string, defaults to "ISO", as for other colour
definitions, which in this case returns \code{NA}.}
}
\description{
Far-red radiation according to "ISO" (not defined) or as commonly defined in
plant photobiology, "Smith10" (725-735 nm), "Smith20" (720-740 nm), "Inada"
(700-800 nm), "Warrington" (700-850 nm), and "Sellaro" (700-750 nm). The
red-edge used in remote sensing of vegetation is centred at the reflectance
transition in the far-red band (725 nm), we define "RedEdge40"
(705-745 nm) and "RedEdge20" (715-735 nm).
}
\note{
The bands are defined as square windows, these can be applied to
spectral data but they do not simulate the sensitivity of broad-band sensors
or the spectral transmittance of filters. Some band-pass interference
filters may have very sharp cut-in and cut-off, and their effect can be
approximated by a square window but filters based on light
absorption will show gradual tails and bell-shaped wavelength-windows.
}
\examples{
Far_red()
Far_red("ISO")
Far_red("Smith")

}
\seealso{
\code{\link{NIR}} for wavebands close to the boundary between red
  and infrared regions.

\code{\link[photobiology]{waveband}}

Other unweighted wavebands: \code{\link{Blue}},
  \code{\link{Green}}, \code{\link{IR}},
  \code{\link{Orange}}, \code{\link{Purple}},
  \code{\link{Red}}, \code{\link{UVA}}, \code{\link{UVB}},
  \code{\link{UVC}}, \code{\link{UV}}, \code{\link{VIS}},
  \code{\link{Yellow}}
}
\concept{unweighted wavebands}
