% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phreeqc.R
\name{phrSetErrorFileName}
\alias{phrSetErrorFileName}
\title{Set the name of the error file.}
\usage{
phrSetErrorFileName(filename)
}
\arguments{
\item{filename}{the name of the file.}
}
\description{
Sets the name of the error file. The default value is phreeqc.0.err.
}
\examples{

# This example equilibrates pure water with calcite and displays
# the log file name.
phrLoadDatabaseString(phreeqc.dat)
phrSetLogFileOn(TRUE)
phrSetLogFileName("phreeqc.log")
input <- c( 
  'SOLUTION 1 Pure water ',
  'EQUILIBRIUM_PHASES 1  ',
  '    Calcite 0 10      '
  )

if (is.null(phrRunString(input))) {
  cat("see", phrGetErrorFileName(), "\\n")
}

}
\references{
\url{ftp://brrftp.cr.usgs.gov/pub/charlton/iphreeqc/IPhreeqc.pdf}
}
\seealso{
Other Error: \code{\link{phrGetErrorFileName}},
  \code{\link{phrGetErrorFileOn}},
  \code{\link{phrGetErrorStringsOn}},
  \code{\link{phrGetErrorStrings}},
  \code{\link{phrSetErrorFileOn}},
  \code{\link{phrSetErrorStringsOn}}
}
