% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phreeqc.R
\name{phrSetErrorFileOn}
\alias{phrSetErrorFileOn}
\title{Set error file on/off.}
\usage{
phrSetErrorFileOn(value)
}
\arguments{
\item{value}{if TRUE, writes output to the the error file.}
}
\description{
Sets the error file switch on or off. This switch controls whether
or not phreeqc writes to the error file. The initial setting is off.
}
\details{
The try is necessary to keep the error message from displaying immediately.
}
\examples{

# This example attempts to run ex1, fails, and writes the error
# message to the error file (no database is loaded).
phrSetErrorFileOn(TRUE)
phrSetErrorFileName(file.path(tempdir(), "phreeqc.errors"))
if (!is.null(try(phrRunString(ex1), silent=TRUE))) {
  cat(paste("see ", phrGetErrorFileName(), ".\n", sep = ""))
}

}
\references{
\url{https://water.usgs.gov/water-resources/software/PHREEQC/IPhreeqc.pdf}
}
\seealso{
Other Error: 
\code{\link{phrGetErrorFileName}()},
\code{\link{phrGetErrorFileOn}()},
\code{\link{phrGetErrorStrings}()},
\code{\link{phrGetErrorStringsOn}()},
\code{\link{phrSetErrorFileName}()},
\code{\link{phrSetErrorStringsOn}()}
}
\concept{Error}
