\name{exampleSummary}
\alias{exampleSummary}
\docType{data}
\title{
Example Tree Summary
}
\description{
An example of \code{treeListSummary} that has been used on the trees accompanying the package: \code{ssTrees}, \code{homTrees} and \code{rTrees}. See the examples section for some interesting plots.
}
\usage{data(exampleSummary)}
\format{
  A data frame with 100 observations on the following 7 variables (including the \code{Type} of the tree).
  \describe{
    \item{\code{avgLadder}}{a numeric vector}
    \item{\code{nLadders}}{a numeric vector}
    \item{\code{maxLadder}}{a numeric vector}
    \item{\code{sackin}}{a numeric vector}
    \item{\code{colless}}{a numeric vector}
    \item{\code{nCherries}}{a numeric vector}
    \item{\code{Type}}{a factor with levels \code{hom} and \code{SS}}
  }
}
\details{
\code{rTrees} were created using \code{rtree4} as the model for \code{modelCreate}. \code{ssTrees} and \code{homTrees} were created by models based on the spread of disease.  They they are from a transmission model with only one pathogen lineage per host. The former had a fifth of the hosts seeding five times as many infections as the others, and  while the latter was homogeneous - everyone was equally infectious. They all have 60 nodes or a little more. Those generated by \code{rtree4} have exactlly 61.
}
\source{
\code{homTrees} and \code{ssTrees} were created by Caroline Colijn of Imperial College London. \code{rTrees} were created with the functions of this package. \code{rtree4} was the model used.
}
\seealso{
\code{\link{modelAnalysis}} for functions to create similar summaries based on your own models.
}
\examples{
# Load data
data(exampleSummary)

# See the format of the data
head(exampleSummary)

# Find the correlations between the numeric vectors in the summary for the two types of trees
# This can be very useful. Observe the differences in correlations 
homCor <- cor(exampleSummary[1:50,1:6])
ssCor <- cor(exampleSummary[51:100,1:6])
randCor <- cor(exampleSummary[101:150,1:6])

\dontrun{
### I WILL NOW ILLUSTRATE SOME USES OF THE PACKAGE
### THESE METHODS USE LIBARY ggplot2
### IT WILL NEED TO BE SEPERATELY INSTALLED IF YOU WISH TO USE IT

# Initialize plot
p <- ggplot(data=exampleSummary) + facet_wrap(~Type)

# A bar plot of nLadders with colors determined by maxLadder 
p + geom_bar(aes(nLadders,fill=factor(maxLadder)),binwidth=1) +
guides(fill=guide_legend(title='maxLadder'))

# A scatter plot of maxLadder against avgLadder
p + geom_point(aes(maxLadder,avgLadder,color=Type)) + theme(legend.position='none')
}
}
\keyword{datasets}
