\name{PLD_plot_stat_mig}

\alias{PLD_plot_stat_mig}

\title{
Plot dispersal statistics
}

\description{
Function that displays the density plots of the dispersal times for each location.
}

\usage{
PLD_plot_stat_mig(timemat, color = NA, xy_legend = NA, group = 0)
}

\arguments{
  \item{timemat}{
a 3-dimensional (a*b*c) array with (a) the departure locations, (b) the destination locations and (c) the time of the dispersal from (a) to (b), generated by a call to \link{PLD_stat_mig}.
}

  \item{color}{
a set of colors for the density plot.
If NA, rainbow (grDevices) is used.
}

 \item{xy_legend}{
a vector of 2 values specifying the legend coordinates.
}
  \item{group}{
locations are grouped according to timemat rownames.
}
}

\examples{
data(Banza)
stat = PLD_stat_mig(x = Banza, sub_sample = 100:200, first = TRUE)
PLD_plot_stat_mig(timemat = stat$timemat)
}

