% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ps_dissim.R
\name{ps_add_dissim}
\alias{ps_add_dissim}
\title{Add community dissimilarity data to a \code{phylospatial} object}
\usage{
ps_add_dissim(ps, method = "sorensen", ...)
}
\arguments{
\item{ps}{\code{phylospatial} data set.}

\item{method}{Dissimilarity metric; see \link{ps_dissim} for details.}

\item{...}{Additional arguments passed to \link{ps_dissim}, such as \code{fun}, \code{endemism}, or \code{normalize}.}
}
\value{
\code{ps} with a new \code{dissim} element added.
}
\description{
This function calculates pairwise phylogenetic dissimilarity between communities and returns the \code{phylospatial}
object with the dissimilarity data added as an element called \code{dissim}. See \link{ps_dissim} for details.
}
\examples{
ps <- ps_simulate(data_type = "prob")
ps_add_dissim(ps)
ps_add_dissim(ps, fun = "vegdist", method = "jaccard", endemism = TRUE)

}
