% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.phylter.R
\name{plot.phylter}
\alias{plot.phylter}
\alias{plot2WR}
\alias{plotDispersion}
\alias{plotRV}
\alias{plotopti}
\title{Plot phylter objects}
\usage{
\method{plot}{phylter}(x, what = "all", layout = 1, sorted = TRUE, ...)

plot2WR(
  x,
  show.missing = TRUE,
  show.outliers = TRUE,
  transpose = FALSE,
  clust = FALSE
)

plotDispersion(x)

plotRV(x, what = "Initial", labelnames = TRUE, clust = FALSE)

plotopti(x)
}
\arguments{
\item{x}{The object returned by the 'phylter()' function.}

\item{what}{Specifies what to plot. If "species", a barplot will show how many
genes each species is in, and what proportion of thoses were detected as outliers. 
If "genes", a barplot shows how many species contains each gene and how many of 
them has been detected as outliers. If "all" (the defaut), the two plots
described above are displayed one after the other, prompting the user to press 
ENTER to display the next one.}

\item{layout}{What layout to use. Do not change if you don't know what it is.}

\item{sorted}{Logical. Should bars be sorted by the number of outliers detected. Default
to TRUE}

\item{...}{Additional arguments to be passed to plot and print functions.}

\item{show.missing}{Logical. Should missing data be represented on the heatmap. If TRUE (the default), white dots show were these missing entries are in both the initial and final 2WR matrices.}

\item{show.outliers}{Logical. Should outliers be represented on the heatmap. If TRUE (the default), yellow dots indicate outliers on the final 2WR matrix.}

\item{transpose}{Logical. If TRUE, the two matrices are piled up instaed of being displayed side by side. Default to FALSE.}

\item{clust}{Logical. Should the rows or/and columns of the matrices that are plotted be reorderd
prior to plotting. Reordering is based on a hierarchical clustering. Default to FALSE. 
This is conveninent when the names of the genes are very long for instance.}

\item{labelnames}{Logical. If TRUE, the names of labels are indicated on the heatmap. If FALSE they are removed. 
This is conveninent when the names of the genes are very long for instance.}
}
\value{
The desired plots are returned. Note that you might want to call the pdf(),
 png(), jpeg(), or tiff() function first if you want to save the plot(s) to an
external file. You can also use the function \code{write.phylter(pdfreport=TRUE)} to write 
all possible plots in a single pdf file.
}
\description{
These functions take objects of class phylter as input
and display various plots summarizing the results obtained (see details).
}
\details{
\itemize{
 \item \code{plot(x)} and \code{plot.phylter(x)} plot the genes found in each species or species 
found in each gene as barplots, highlighting the outliers detected.
 \item \code{plot2WR(x)} plots side by side the initial and the final gene x species (unreable for large datasets) 
matrices (the 2WR matrices), highlighting missing data and detected outliers.
 \item \code{plotDispersion(x)} plots dispersion of data before and after phylter, on a 2D
space. Each dot represents a gene-species association. 
\item \code{plotRV(x)} plots the RV coefficient matrix that descibes all agains all correlations between gene matrices
\item \code{plotopti(x)} plots the compromise matrix score at each step of the 
optimization.  
}
}
\examples{
data(carnivora)

# perform phylter analysis
res <- phylter(carnivora, parallel = FALSE)

# plot for each gene the number of outlier species
plot(res, "genes")

\donttest{
# plot for each species the number genes where it is outlier
plot(res, "species")

# plot the dispersion of data before and after the use of phylter
plotDispersion(res)
}

}
