% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/bmi.R
\name{ideal_weight_adult}
\alias{ideal_weight_Broca}
\alias{ideal_weight_Devine}
\alias{ideal_weight_Lemmens}
\alias{ideal_weight_Miller}
\alias{ideal_weight_Robinson}
\alias{ideal_weight_adult}
\alias{ideal_weight_child}
\alias{ideal_weight_linear}
\title{ideal weight for adults}
\usage{
ideal_weight_adult(heightm, male, ...)

ideal_weight_child(heightm, age.years = NULL, age.months = NULL,
  age.days = NULL, warn = FALSE)

ideal_weight_Devine(heightm, male, ...)

ideal_weight_Robinson(heightm, male, ...)

ideal_weight_Miller(heightm, male, ...)

ideal_weight_Broca(heightm, male, ...)

ideal_weight_Lemmens(heightm)

ideal_weight_linear(heightm, male, heightmininch, male_min_kg, female_min_kg,
  male_kg_per_inch, female_kg_per_inch, warn = FALSE)
}
\arguments{
\item{heightm}{single numeric, height in meters}

\item{male}{logical value(s) whether patient is male. TRUE or FALSE.}

\item{...}{arguments passed to downstream functions, e.g. \code{warn = TRUE}}

\item{age.years}{numeric vector, age(s) in years}

\item{age.months}{numeric vector, age(s) in months}

\item{age.days}{numeric vector, age(s) in days}

\item{warn}{single logical, if TRUE, will produce warnings for very
unrealistic physical measurements, and other minor problems}

\item{heightmininch,}{height above which to start scaling; consider as a
minimum (for at least some algorithms)}

\item{male_min_kg,}{y intercept i.e. ideal weight at minimum height for males}

\item{female_min_kg,}{y intercept i.e. ideal weight at minimum height for
females}

\item{male_kg_per_inch,}{slope for males}

\item{female_kg_per_inch,}{slope for females}

\item{heightm}{single numeric, height in meters}

\item{warn}{single logical, if TRUE, will produce warnings for very
unrealistic physical measurements, and other minor problems}
}
\description{
\code{ideal_weight_adult} gives the ideal weight using default
  adult algorithm, Devine.

  TODO: param to switch to different method without knowing the function
  name.

\code{ideal_weight_} gives the ideal weight using default
  paediatric algorithm. TODO: account for Down's/other well calibrated
  developmental differences. Age specifications are mutually exclusive, and
  an error will be generated if more than on age i specified per patient.

Devine method is the default and most widely used. Normally
  stated in inches. Male: 50kg + 2.3kg * inches over 5ft. Female: 45.5kg +
  2.3kg * inches over 5ft. (from 1974 genatamicin paper - see Lemmens for
  ref.)

Robinson's method for ideal weight: different linear
  relationship. (Robinson JD, Lupkiewicz SM, Palenik L et al. Determination
  of ideal body weight for drug dosage calculations. Am J Hosp Pharm 1983;
  40: 1016-9.)

Miller's method for ideal weight: different linear relationship.
  (Miller DR, Carlson JD, Loyd BJ et al. Determining ideal body weight.
  (Letter). Am J Hosp Pharm 1983; 40: 1622.)

Calculate ideal weight based on Broca (1871) Height in cm -100
  for women, -105 for men Broca PP. Memoires d'anthropologie. Paris 1871 /
  1877.

Lemmens merhod assumes BMI 22 as ideal (Obesity Surgery 2005)
TODO: verbose height bounds check

generic internal function to handle linear ideal weight
  calculations. Unofrtunately mixes inches and meters at present.
}
\examples{
ideal_weight_adult(1.7, TRUE)
ideal_weight_adult(1.7, FALSE)
ideal_weight_adult(6 * 12 * 2.54, TRUE)
}
\keyword{internal}

