% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airway.R
\name{ett_vol_ml}
\alias{ett_vol_ml}
\title{Estimate volume inside an endotracheal tube}
\usage{
ett_vol_ml(diameter_mm)
}
\arguments{
\item{diameter_mm}{The internal diameter of the endotracheal tube in
millimeters. Sizes between 2.0 and 8 are offered. Half sizes between 2.5
and 6 are accepted.}
}
\value{
Volumes of each given ETT in cubic millimeters
}
\description{
Calculations are based on standard endotracheal tubes. The volume is
estimated as the cylinder of the given diameter and typical length of a tube
of given size.
}
\examples{
ett_vol_ml(2:8)
plot(2:8, ett_vol_ml(2:8))
lines(2:8, ett_vol_ml(2:8),
  xlab = "ETT internal diameter, mm",
  ylab = "ETT internal volume, mm^3")
(vols_cm3 <- ett_vol_ml(seq(2, 6, 0.5)) / 1000)

# Ages through to ETT internal volume
ett_vol_ml(ett_size_by_age(1:10))

}
\seealso{
Other airway equipment: \code{\link{deadspace_things_ml}},
  \code{\link{deadspace_total}},
  \code{\link{ett_size_by_age}}
}
\concept{airway equipment}
