% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpqr.R
\name{dpqr}
\alias{dpqr}
\title{d/p/q/r-family for a custom distribution}
\usage{
dpqr(fun, min, max)
}
\arguments{
\item{fun}{distribution function of a single variable; does not have to be normalized}

\item{min, max}{domain of distribution function; outside this domain \code{fun} will be considered equal to 0. In practice, this should be the most restrictive domain containing (almost) all the mass of \code{fun}.}
}
\value{
Returns a list of items:
\item{d(x)}{Probability distribution function (PDF), i.e. a normalised version of \code{fun}, limited to the domain \code{[xmin,xmax]}.}
\item{p(x)}{Cumulative distributiont function, defined as the integrated PDF up to x.}
\item{q(p)}{Quantile function, returning the position x, at which the cumulative probability equals \code{p}.}
\item{r(n)}{A vector of \code{n} random numbers drawn from the PDF.}
}
\description{
Produces the family of d/p/q/r functions associated with a custom one-dimensional distribution function; similarly to the standard families dnorm/pnorm/qnorm/rnorm, dunif/punif/...
}
\examples{

f = function(x) sin(x)
rsin = dpqr(f,0,pi)$r
x = rsin(1e3)
hist(x,freq=FALSE)
curve(sin(x)/2,0,pi,add=TRUE)

}
\seealso{
\code{\link{rng}}, \code{\link{contourlevel}}
}
\author{
Danail Obreschkow
}
