\name{optim.phylo.ls}
\alias{optim.phylo.ls}
\title{Phylogeny inference using the least squares method}
\usage{
optim.phylo.ls(D, stree=NULL, set.neg.to.zero=TRUE, fixed=FALSE,
     tol=1e-10, collapse=TRUE)
}
\arguments{
  \item{D}{a distance matrix.}
  \item{stree}{an optional starting tree for the optimization.}
  \item{set.neg.to.zero}{a logical value indicating whether to set negative branch lengths to zero (default \code{TRUE}).}
  \item{fixed}{a logical value indicating whether to estimate the topology - if \code{TRUE} only the branch lengths will be computed.}
  \item{tol}{a tolerance value used to assess whether the optimization has converged.}
  \item{collapse}{ a logical indicating whether to collapse branches with zero length.}
}
\description{
  This function performs phylogeny inference using least-squares.
}
\details{
  Function uses \code{nni} from the "phangorn" package (Schliep 2011) to conduct NNIs for topology estimation.
}
\value{
  a \code{"phylo"} that (may be) the least-squares tree with branch lengths; also returns the sum of squares in \code{attr(tree,"Q-score")}.
}
\references{
  Cavalli-Sforza, L. L., and A. W. F. Edwards. 1967. Phylogenetic analysis: Modesl and estimation procedures.  \emph{American Journal of Human Genetics}, \bold{19}, 233-257.

  Felsenstein, J. 2004. \emph{Inferring Phylogenies}. Sinauer.

  Paradis, E., J. Claude, and K. Strimmer. 2004. APE: Analyses of phylogenetics and evolution in R language. \emph{Bioinformatics}, \bold{20}, 289--290.

  Schliep, K. P. 2011. phangorn: phylogenetic analysis in R. \emph{Bioinformatics}, \bold{27}, 592-593.
}
\author{Liam Revell \email{liam.revell@umb.edu}}
\seealso{
  \code{\link{exhaustiveMP}}, \code{\link{nni}}
}
\keyword{phylogenetics}
\keyword{inference}
\keyword{distance matrix}
\keyword{least squares}
