% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/price_relative.R
\name{price_relative}
\alias{price_relative}
\title{Calculate period-over-period price relatives}
\usage{
price_relative(x, period, product)
}
\arguments{
\item{x}{A numeric vector of prices.}

\item{period}{A factor, or something that can be coerced into one, that
gives the corresponding time period for each element in \code{x}. The
ordering of time periods follows the levels of \code{period} to agree with
\code{\link[=cut.Date]{cut()}}.}

\item{product}{A factor, or something that can be coerced into one, that
gives the corresponding product identifier for each element in \code{x}.}
}
\value{
A numeric vector of price relatives, with \code{product} as names.
}
\description{
Construct period-over-period price relatives from information on prices and
products over time.
}
\examples{
price_relative(1:6, rep(1:2, each = 3), rep(letters[1:3], 2))

}
\seealso{
\code{\link[gpindex:back_period]{gpindex::back_period()}} to get only the back price.

\code{\link[gpindex:back_period]{gpindex::base_period()}} for making fixed-base price relatives.

\code{\link[=carry_forward]{carry_forward()}} and \code{\link[=shadow_price]{shadow_price()}} to impute missing prices.

\code{\link[gpindex:outliers]{gpindex::outliers}} for methods to identify outliers with price relatives.
}
