sem.lavaan = function(modelList, data, corr.errors = NULL, add.vars = NULL, ...) {

  if(is.null(data)) stop("Must supply dataset to function")
  
  # Convert model formula to lavaan syntax
  sem.model = paste(c(unlist(lapply(modelList, function(i) {
    
    if(all(class(i) %in% c("lmerMod", "merModLmerTest", "glmerMod"))) 
      
      rhs = format(nobars(formula(i))) else
        
        rhs = format(formula(i))
    
    paste(rhs, collapse = "") } ) ), corr.errors), collapse = "\n")

  if(!is.null(add.vars)) 
    
    sem.model = paste(
      sem.model, 
      paste(unname(sapply(add.vars, function(x) as.formula(paste(x, x, sep = " ~ ")))), collapse = "\n"), sep = "\n")

  # Run lavaan SEM
  model = sem(sem.model, data, ...)

  return(model)
  
}