% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paf_combine.R
\name{paf.combine}
\alias{paf.combine}
\title{Combine point estimates of PAF from different subpopulations}
\usage{
paf.combine(paf_vector, proportions)
}
\arguments{
\item{paf_vector}{Vector containing \code{\link{paf}}s of each specific 
subpopulation.}

\item{proportions}{Vector establishing the proportion of individuals in each 
subpopulation.}
}
\value{
overall_paf An overall point-estimate of \code{\link{paf}} combining all 
  subpopulations.
}
\description{
Function for fast-computing an overall  \code{\link{paf}} 
 from subpopulation  \code{\link{paf}}s.
}
\details{
The subpopulations considered should not contain common elements.
}
\examples{

#Example 1
#-------------

#Estimate PAF for each subpopulation
pafmen   <- paf(X = data.frame(2.7), thetahat = 0.12, 
                rr = function(X, theta){X*theta + 1},
                Xvar = 0.11, method = "approximate")
pafwomen <- paf(X = data.frame(3.1), thetahat = 0.12, 
                rr = function(X, theta){exp(X*theta/3)},
                Xvar = 0.17, method = "approximate")

#Combine estimates
paf.combine(c(pafmen, pafwomen), c(0.45, 0.55))  


}
\seealso{
\code{\link{paf}} for Population Attributable Fraction estimation, 
  \code{\link{pif}} for Potential Impact Fraction estimation, and 
  \code{\link{pif.combine}} for combining several PIF.
}
\author{
Rodrigo Zepeda-Tello \email{rzepeda17@gmail.com}

Dalia Camacho-García-Formentí \email{daliaf172@gmail.com}
}
