% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pb_upload.R
\name{pb_upload}
\alias{pb_upload}
\title{Upload data to an existing release}
\usage{
pb_upload(file, repo = guess_repo(), tag = "latest", name = NULL,
  overwrite = TRUE, use_timestamps = TRUE, show_progress = TRUE,
  .token = get_token(), dir = ".")
}
\arguments{
\item{file}{path to file to be uploaded}

\item{repo}{Repository name in format "owner/repo". Will guess the current
repo if not specified.}

\item{tag}{tag for the GitHub release to which this data should be attached.}

\item{name}{name for uploaded file. If not provided will use the basename of
\code{file} (i.e. filename without directory)}

\item{overwrite}{overwrite any existing file with the same name already
attached to the on release? Defaults to \code{TRUE}}

\item{use_timestamps}{logical, if \code{TRUE}, then files will only be downloaded
if timestamp on GitHub is newer than the local timestamp (if
\code{overwrite=TRUE}).  Defaults to \code{TRUE}.}

\item{show_progress}{logical, show a progress bar be shown for uploading?
Defaults to \code{TRUE}.}

\item{.token}{GitHub authentication token. Typically set from an
environmental variable, e.g. in a \code{.Renviron} file or with
\code{Sys.setenv(GITHUB_TOKEN = "xxxxx")}, which helps prevent accidental
disclosure of a secret token when sharing scripts.}

\item{dir}{directory relative to which file names should be based.}
}
\description{
NOTE: you must first create a release if one does not already exists.
}
\examples{
\dontrun{
# Needs your real token to run

readr::write_tsv(mtcars,"mtcars.tsv.xz")
pb_upload("mtcars.tsv.xz", "cboettig/piggyback-tests")
}
}
