% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlaceSpecialBet.R
\name{PlaceSpecialBet}
\alias{PlaceSpecialBet}
\title{Place a Special Bet on a Given Contestant}
\usage{
PlaceSpecialBet(stake, lineId, specialId, contestantId,
  acceptBetterLine = TRUE, winRiskStake = "RISK", oddsFormat = "AMERICAN")
}
\arguments{
\item{stake}{The amount to be wagered.}

\item{lineId}{The line to wager on. See \code{\link{GetSpecialLine}}.}

\item{specialId}{The ID of the special offer.}

\item{contestantId}{The ID of the contestant wagered on.}

\item{acceptBetterLine}{Whether or not to accept a bet when there is a line
change in favour of this wager.}

\item{winRiskStake}{Whether the stake is the risk or win amount. One of
\code{"RISK"} or \code{"WIN"}.}

\item{oddsFormat}{Format for the returned odds. One of \code{"AMERICAN"},
\code{"DECIMAL"}, \code{"HONGKONG"}, \code{"INDONESIAN"}, or
\code{"MALAY"}.}
}
\value{
A data frame with the following columns:

\describe{
  \item{\code{status}}{When the wager is placed this will contain code
    \code{"ACCEPTED"}. Otherwise it will contain code
    \code{"PROCESSED_WITH_ERROR"}.}
  \item{\code{errorCode}}{When the wager is not accepted, this column
    will contain a code for the particular error involved; otherwise it will
    be \code{NA}.}
  \item{\code{uniqueRequestId}}{A unique ID associated with the wager.}
}

When the wager is accepted, the data frame will also contain the following:

\describe{
  \item{\code{betId}}{A unique ID for the newly created bet.}
  \item{\code{betterLineWasAccepted}}{Whether or not the bet was accepted on
    a line that changed in favour of wager.}
}

When the wager is not accepted, the data frame may also contain
\code{lineId} and \code{specialBet} columns with NA values.
}
\description{
Place a wager on a contestant in a given special line.
}
\details{
This function will raise an error if the API does not return HTTP status
\code{OK}, which is not precisely the same as an assurance that the wager
was placed successfully (see the Value section). For information on the
possible errors, see the API documentation for
\href{https://pinnacleapi.github.io/betsapi#operation/Bets_Special}{Place Special Bet}.
}
\examples{
\donttest{
SetCredentials("TESTAPI", "APITEST")
AcceptTermsAndConditions(accepted = TRUE)

# This contest is unlikely to exist, but serves as an example
# of the format.
line <- GetSpecialLine(specialId = 101, contestantId = 102,
                       oddsFormat = "AMERICAN")

if (!is.na(line$lineId)) {
  PlaceSpecialBet(stake = 100, lineId = line$lineId,
                  specialId = 101, contestantId = 102,
                  acceptBetterLine = TRUE,
                  winRiskStake = "RISK",
                  oddsFormat = "AMERICAN")
}
}

}
\seealso{
See \code{\link{PlaceBet}} to make non-special wagers,
\code{\link{GetSpecialFixtures}} to query available special contestants, and
\code{\link{GetSpecialLine}} to get their associated lines.
}
