% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legacy_kaggle.R
\name{legacy_kaggle}
\alias{legacy_kaggle}
\alias{board_register_kaggle}
\title{Kaggle board (legacy API)}
\usage{
legacy_kaggle(token = NULL, name = "kaggle", ...)

board_register_kaggle(name = "kaggle", token = NULL, cache = NULL, ...)
}
\arguments{
\item{token}{The Kaggle token as a path to the \code{kaggle.json} file, can
be \code{NULL} if the \verb{~/.kaggle/kaggle.json} file already exists.}

\item{name}{An optional name used identify the board. This is no longer
generally needed since you should be passing around an explicit
board object.}

\item{...}{Additional parameters required to initialize a particular board.}

\item{cache}{Cache path. Every board requires a local cache to avoid
downloading files multiple times. The default stores in a standard
cache location for your operating system, but you can override if needed.}
}
\description{
To use a Kaggle board, you need to first download a token file from
your account.
}
\section{Sharing}{
When working in teams, you might want to share your pins with others. For
You can do by adding users or making the dataset public on Kaggle's website.

Once you share with specific users, they can follow the same steps to
register a Kaggle board which allows them to download and upload pins
}

\examples{
\dontrun{
# the following example requires a Kaggle API token
board <- legacy_kaggle(token = "path/to/kaggle.json")

pin_find("crowdflower", board = board)

# names starting with c/ are competitions
pin_get("c/crowdflower-weather-twitter", board = board)
}
}
